/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"


static void kernel_ext_tsk(VP_INT exinf);	/* νλ(ƥॿǼ¹) */



/* νλ */
void ext_tsk(void)
{
	T_KERNEL_TCB_RAM *tcb_ram;
	T_MKNL_TCB       *mtcb_run;

	/* ¹楿μ */
	mtcb_run = mknl_get_run_tsk();
	tcb_ram  = KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb_run);

	mknl_loc_sys();		/* ƥΥå */

	/* ƥॿԤ */
	mknl_exe_sys((FP)kernel_ext_tsk, (VP_INT)tcb_ram);
}



/* νλ(ƥॿǼ¹) */
void kernel_ext_tsk(VP_INT exinf)
{
	const T_KERNEL_TCB_ROM *tcb_rom;
	T_KERNEL_TCB_RAM       *tcb_ram;
	
	tcb_ram = (T_KERNEL_TCB_RAM *)exinf;
	tcb_rom = tcb_ram->tcb_rom;
	
	/* λ */
	mknl_ter_tsk(&tcb_ram->mtcb);

	/* ư塼󥰤Ƥʤ */
	if ( tcb_ram->actcnt > 0 )
	{
		tcb_ram->actcnt--;		/* 塼󥰸 */
		tcb_ram->suscnt = 0;	/* Ԥͥȥꥢ */
		tcb_ram->wupcnt = 0;	/* Ԥ׵ᥭ塼󥰥ꥢ */

		/* ٥ */
		mknl_sta_tsk(
				&tcb_ram->mtcb,			/* Ͽ륿 */
				tcb_rom->exinf,			/* γĥ */
				(FP)kernel_task_entry,	/* εư */
				tcb_rom->itskpri,		/* εưͥ */
				tcb_rom->stksz,			/* Υåΰ襵 */
				tcb_rom->stk			/* ΥåΰƬ */
			);	
	}
	
	/* ǥѥåμ¹ */
	mknl_exe_dsp();
}



/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2006 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
