/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ͥ٤ѹ */
ER chg_pri(
		ID tskid,		/* ѹоݤΥIDֹ */
		PRI tskpri)		/* ѹΥ١ͥ */
{
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
	if ( tskid != TSK_SELF && (tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID) )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	/* ѥ᡼ϰϥå */
#ifdef HOS_ERCHK_E_PAR
	if ( tskpri < TMIN_TPRI || tskpri > TMAX_TPRI )
	{
		return E_PAR;	/* ѥ᡼ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ȥ֥å */
	if ( tskid == TSK_SELF )
	{
		/* Ѵ */
#ifdef HOS_ERCHK_E_ID
		if ( mknl_sns_ctx() )
		{
			/* 󥿥ƥȤ TSK_SELF */
			mknl_unl_sys();		/* ƥΥå */
			return E_ID;		/* IDֹ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
	}
	else
	{
		/* IDֹѴ */
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();		/* ƥΥå */
			return E_NOEXS;		/* ֥̤ */
		}
#endif
	}

	/* ưͥٻξ */
	if ( tskpri == TPRI_INI )
	{
		tskpri = tcb_ram->tcb_rom->itskpri;
	}

	/* ֥Ȥξ֥å */
#ifdef HOS_ERCHK_E_OBJ
	if ( mknl_get_tskstat(&tcb_ram->mtcb) == TTS_DMT )	/* ٻ߾֤ʤ */
	{
		return E_OBJ;	/* ֥Ⱦ֥顼 */
	}
#endif

	/* ͥѹ */
	mknl_chg_pri(&tcb_ram->mtcb, tskpri);
	
	mknl_exe_dsp();		/* ǥѥåμ¹ */
	mknl_exe_tex();		/* 㳰μ¹ */
	
	mknl_unl_sys();		/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
