/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2006 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpl.h"



/* Ĺס */
ER cre_mpl(
		ID           mplid,		/* оݤβĹסIDֹ */
		const T_CMPL *pk_cmpl)	/* Ĺס줿ѥåȤؤΥݥ */
{
	ER ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mplid < KERNEL_TMIN_MPLID || mplid > KERNEL_TMAX_MPLID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ס뤬Ͽǽɤå */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_MPLID_TO_MPLCB_RAM(mplid) != NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_OBJ;	/* ϿѤ */
	}
#endif

	/* Ĺס */
	ercd = kernel_cre_mpl(mplid, pk_cmpl);
	
	mknl_unl_sys();	/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2006 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
