/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2006 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpl.h"



/* Ĺס(IDֹ漫ưդ) */
ER_ID acre_mpl(
		const T_CMPL *pk_cmpl)	/* Ĺס줿ѥåȤؤΥݥ */
{
	ID mplid;
	ER ercd;

	mknl_loc_sys();	/* ƥΥå */

	/* ѲǽIDθ */
	for ( mplid = KERNEL_TMAX_MPLID; mplid >= KERNEL_TMIN_MPLID; mplid-- )
	{
		if ( KERNEL_MPLID_TO_MPLCB_RAM(mplid) == NULL )
		{
			break;
		}
	}
	
	/* IDֹ­å */
#ifdef HOS_ERCHK_E_NOID
	if ( mplid < KERNEL_TMIN_MPLID )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOID;	/* IDֹ­ */
	}
#endif

	/* Ĺס */
	ercd = kernel_cre_mpl(mplid, pk_cmpl);
	if ( ercd != E_OK )
	{
		mknl_unl_sys();	/* ƥΥå */
		return (ER_ID)ercd;
	}
	
	mknl_unl_sys();	/* ƥΥå */

	return (ER_ID)mplid;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2006 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
