/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ᡼ܥå                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbx.h"
#include "knl_sys.h"



/* ᡼ܥåξֻ */
ER ref_mbx(
		ID     mbxid,		/* ֻоݤΥ᡼ܥåIDֹ */
		T_RMBX *pk_rmbx)	/* ᡼ܥå֤֤ѥåȤؤΥݥ */
{
	const T_KERNEL_MBXCB_ROM *mbxcb_rom;
	T_KERNEL_MBXCB_RAM       *mbxcb_ram;
	T_MKNL_TCB *mtcb;
	PRI        msgpri;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mbxid < KERNEL_TMIN_MBXID || mbxid > KERNEL_TMAX_MBXID )
	{
		return E_ID;
	}
#endif

	/* ѥ᡼Υå */
#ifdef HOS_ERCHK_E_PAR
	if ( pk_rmbx == NULL )
	{
		return E_PAR;	/* ѥ᡼顼 */
	}
#endif
	
	mknl_loc_sys();	/* ƥΥå */

	mbxcb_ram = KERNEL_MBXID_TO_MBXCB_RAM(mbxid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbxcb_ram == NULL )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_NOEXS;
	}
#endif

	mbxcb_rom = mbxcb_ram->mbxcb_rom;

	/* ᡼ܥåԤƬΥIDֹ */
	mtcb = mknl_ref_qhd(&mbxcb_ram->que);	/* ԤƬ饿Ф */
	if ( mtcb == NULL )
	{
		pk_rmbx->wtskid = TSK_NONE;		/* Ԥʤ */
	}
	else
	{
		/* ID򸡺 */
		pk_rmbx->wtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* åͥٽ˸ */
	for ( msgpri = 0; msgpri <= mbxcb_rom->maxmpri - TMIN_MPRI; msgpri++ )
	{
		if ( mbxcb_rom->mprihd[msgpri] != NULL )
		{
			break;
		}
	}

	if ( msgpri <= mbxcb_rom->maxmpri - TMIN_MPRI )
	{
		/* ᡼ܥå˥ǡмФ */
		pk_rmbx->pk_msg = mbxcb_rom->mprihd[msgpri];
	}
	else
	{
		/* ᡼ܥåʤ */
		pk_rmbx->pk_msg = NULL;
	}

	mknl_unl_sys();	/* ƥΥå */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
