/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǡ塼                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"
#include "knl_sys.h"



/* ǡ塼ξֻ */
ER ref_dtq(
		ID     dtqid,		/* ֻоݤΥǡ塼IDֹ */
		T_RDTQ *pk_rdtq)	/* ǡ塼֤֤ѥåȤؤΥݥ */
{
	T_KERNEL_DTQCB_RAM       *dtqcb_ram;
	T_MKNL_TCB *mtcb;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( dtqid < KERNEL_TMIN_DTQID || dtqid > KERNEL_TMAX_DTQID )
	{
		return E_ID;
	}
#endif

	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR 
	if ( pk_rdtq == NULL )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	dtqcb_ram = KERNEL_DTQID_TO_DTQCB_RAM(dtqid);

	/* ֥Ȥ¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( dtqcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif
	
	/* ǡ塼ԤƬΥIDֹ */
	mtcb = mknl_ref_qhd(&dtqcb_ram->sndque);	/* ԤƬ饿Ф */
	if ( mtcb == NULL )
	{
		pk_rdtq->stskid = TSK_NONE;		/* Ԥʤ */
	}
	else
	{
	/* ID򸡺 */
		pk_rdtq->stskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* ٥ȥե饰μԤƬΥIDֹ */
	mtcb = mknl_ref_qhd(&dtqcb_ram->rcvque);	/* ԤƬ饿Ф */
	if ( mtcb == NULL )
	{
		pk_rdtq->rtskid = TSK_NONE;		/* Ԥʤ */
	}
	else
	{
		/* ID򸡺 */
		pk_rdtq->rtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* ǡμ */
	pk_rdtq->sdtqcnt = dtqcb_ram->datacnt;

	mknl_unl_sys();	/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
