/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǡ塼                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"



/* ǡ塼(IDֹ漫ưդ) */
ER_ID acre_dtq(
		const T_CDTQ *pk_cdtq)	/* ǡ塼줿ѥåȤؤΥݥ */
{
	ID dtqid;
	ER ercd;

	mknl_loc_sys();	/* ƥΥå */

	/* ѲǽIDθ */
	for ( dtqid = KERNEL_TMAX_DTQID; dtqid >= KERNEL_TMIN_DTQID; dtqid-- )
	{
		if ( KERNEL_DTQID_TO_DTQCB_RAM(dtqid) == NULL )
		{
			break;
		}
	}
	
	/* IDֹ­å */
#ifdef HOS_ERCHK_E_NOID
	if ( dtqid < KERNEL_TMIN_DTQID )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOID;	/* IDֹ­ */
	}
#endif

	/* ǡ塼 */
	ercd = kernel_cre_dtq(dtqid, pk_cdtq);
	if ( ercd != E_OK )
	{
		mknl_unl_sys();	/* ƥΥå */
		return (ER_ID)ercd;
	}
	
	mknl_unl_sys();	/* ƥΥå */

	return (ER_ID)dtqid;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
