/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ϥɥ                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_cyc.h"
#include "knl_mem.h"



/* ϥɥ(ͥ) */
ER kernel_cre_cyc(
		ID           cycid,		/* оݤμϥɥIDֹ */
		const T_CCYC *pk_ccyc)	/* ϥɥ줿ѥåȤؤΥݥ */
{
	T_KERNEL_CYCCB_RAM *cyccb_ram;
	T_KERNEL_CYCCB_ROM *cyccb_rom;
	SIZE memsize;
	UB   *memptr;
	
	/* ɬפʥꥵ׻ */
	memsize = sizeof(T_KERNEL_CYCCB_RAM) + sizeof(T_KERNEL_CYCCB_ROM);
	
	/*  */
	memptr = (UB *)kernel_alc_mem(memsize);
#ifdef HOS_ERCHK_E_NOMEM
	if ( memptr == NULL )
	{
		return E_NOMEM;		/* ­ */
	}
#endif

	/* ݥ */	
	cyccb_ram  = (T_KERNEL_CYCCB_RAM *)memptr;
	memptr  += sizeof(T_KERNEL_CYCCB_RAM);
	cyccb_rom  = (T_KERNEL_CYCCB_ROM *)memptr;

	/*  */
	cyccb_ram->timobj.timhdr = kernel_cyc_hdr; /* ϥɥϿ */
	cyccb_ram->timobj.next   = NULL;            /* ޥꥹ̤³ */
	cyccb_ram->cyccb_rom     = cyccb_rom;	/* ϥɥ饳ȥ֥åROMؤΥݥ */
	cyccb_rom->cycatr  = pk_ccyc->cycatr;	/* ϥɥ° */
	cyccb_rom->exinf   = pk_ccyc->exinf;	/* ϥɥγĥ */
	cyccb_rom->cychdr  = pk_ccyc->cychdr;	/* ϥɥεư */
	cyccb_rom->cyctim  = pk_ccyc->cyctim;	/* ϥɥεư */
/*	cyccb_rom->cycphs  = pk_ccyc->cycphs;*/	/* ϥɥεư */

	/* ϥɥ饳ȥ֥åơ֥Ͽ */
	KERNEL_CYCID_TO_CYCCB_RAM(cycid) = cyccb_ram;

	/* ¹°ʤг */
	if ( pk_ccyc->cycatr & TA_STA )
	{
		/* ޥꥹȤɲ */
		cyccb_ram->lefttim = pk_ccyc->cyctim;
		kernel_add_tml((T_KERNEL_TIM *)cyccb_ram);
	}

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
