/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*   ץåݲݡͥ (ARM)                                 */
/*   ߥޥ                                                     */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "mknl.h"



/* Хѿ */
UW hospac_arm_imsk  = ARM_IMSK_USR_MODE;		/* ߥޥ */
UW hospac_arm_bimsk = ARM_IMSK_USR_MODE;		/* ١ߥޥ */


/* ߥޥ */
ER chg_imsk(IMSK imsk)
{
	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR
	if ( (imsk & ~(ARM_IMSK_FIQ | ARM_IMSK_IRQ)) != 0 )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();		/* ƥΥå */

	hospac_arm_bimsk = (imsk | ARM_IMSK_USR_MODE);
	
	if ( !mknl_sns_ctx() )
	{
		hospac_arm_imsk = hospac_arm_bimsk;
	}
	else
	{
		hospac_arm_imsk |= hospac_arm_bimsk;
	}

	mknl_unl_sys();		/* ƥΥå */

	return E_OK;
}


/* ߥޥλ */
ER get_imsk(IMSK *p_imsk)
{
	*p_imsk = (hospac_arm_bimsk & (ARM_IMSK_FIQ | ARM_IMSK_IRQ));
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
