/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå                                  */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_tsk_h__
#define __HOS_V4__knl_tsk_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* IDϰ */
#define KERNEL_TMIN_TSKID	TMIN_TSKID			/* IDκǾ */
#define KERNEL_TMAX_TSKID	(KERNEL_TMIN_TSKID + kernel_tcb_cnt - 1)
												/* IDκ */

/* ӥåȥѥΥӥåȿ */
#define TBIT_TEXPTN			16					/* 㳰װΥӥåȿ */
												/* IDκ */


/* 塼󥰡ͥȲκ */
#define TMAX_ACTCNT			255					/* ư׵ᥭ塼󥰿κ */
#define TMAX_WUPCNT			65535				/* ׵ᥭ塼󥰿κ */
#define TMAX_SUSCNT			255					/* Ԥ׵ͥȿκ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/*  */
typedef struct t_ctsk
{
	ATR     tskatr;			/* ° */
	VP_INT  exinf;			/* γĥ */
	FP      task;			/* εư */
	PRI     itskpri;		/* εưͥ */
	SIZE    stksz;			/* åΰΥ(Хȿ) */
	VP      stk;			/* åΰƬ */
} T_CTSK;

/*  */
typedef struct t_rtsk
{
	STAT   tskstat;			/*  */
	PRI    tskpri;			/* θͥ */
	PRI	   tskbpri;			/* Υ١ͥ */
	STAT   tskwait;			/* Ԥװ */
	ID     wobjid;			/* ԤоݤΥ֥ȤIDֹ */
	TMO    lefttmo;			/* ॢȤޤǤλ */
	UINT   actcnt;			/* ư׵ᥭ塼󥰲 */
	UINT   wupcnt;			/* ׵ᥭ塼󥰲 */
	UINT   suscnt;			/* Ԥ׵ͥȲ */
	VP_INT exinf;			/* γĥ */
} T_RTSK;

/* (ʰ) */
typedef struct t_rtst
{
	STAT   tskstat;			/*  */
	STAT   tskwait;			/* Ԥװ */
	VP_INT exinf;			/* γĥ */
} T_RTST;


/* 㳰ȥ֥å(RAM) */
typedef struct t_kernel_texcb_ram
{
	TEXPTN rasptn;			/* 㳰Υ㳰װ */
	FP     texrtn;			/* 㳰εư */
} T_KERNEL_TEXCB_RAM;


/* ȥ֥å(ROM) */
typedef struct t_kernel_tcb_rom
{
	ATR    tskatr;			/* ° */
	VP_INT exinf;			/* γĥ */
	FP     task;			/* εư */
	PRI    itskpri;			/* εưͥ */
	SIZE   stksz;			/* ΥåΥʥХȿ */
	VP	   stk;				/* ΥåΰƬ */
} T_KERNEL_TCB_ROM;


/* ȥ֥å(RAM) */
typedef struct t_kernel_tcb_ram
{
	T_MKNL_TCB mtcb;		/* ̥ͥ ȥ֥å */	
	UB         actcnt;		/* ư׵ᥭ塼󥰿 */
	UB         suscnt;		/* SUSPEND׵ͥȿ */
	UH         wupcnt;		/* ׵ᥭ塼󥰿 */
	T_KERNEL_TEXCB_RAM     *texcb;		/* 㳰ȥ֥åؤΥݥ */
	const T_KERNEL_TCB_ROM *tcb_rom;	/* ȥ֥åROMؤΥݥ */
} T_KERNEL_TCB_RAM;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/*  */
extern       T_KERNEL_TCB_RAM* kernel_tcb_ram_tbl[];		/* ȥ֥åơ֥(RAM) */
extern const INT kernel_tcb_cnt;							/* ȥ֥åĿ */

/* Ѵޥ */
#define KERNEL_TSKID_TO_TCB_RAM(tskid)	(kernel_tcb_ram_tbl[(tskid) - KERNEL_TMIN_TSKID])
															/* IDTCB RAMɥ쥹 */



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ǽ */
void    kernel_ini_tsk(void);								/* ν */
ER      cre_tsk(ID tskid, const T_CTSK *pk_ctsk);			/*  */
ER_ID   acre_tsk(const T_CTSK *pk_ctsk);					/* (IDֹ漫ưդ) */
ER      kernel_cre_tsk(ID tskid, const T_CTSK *pk_ctsk);	/* (ͥ) */
ER      del_tsk(ID tskid);									/* κ */
ER      act_tsk(ID tskid);									/* εư */
#define	iact_tsk	act_tsk									/* εư(󥿥ƥѥޥ) */
ER_UINT can_act(ID tskid);									/* ư׵Υ󥻥 */
ER      sta_tsk(ID tskid, VP_INT stacd);					/* εư(ưɻ) */
void    ext_tsk(void);										/* νλ */
void    exd_tsk(void);										/* νλȺ */
ER      ter_tsk(ID tskid);									/* ζλ */
ER      chg_pri(ID tskid, PRI tskpri);						/* ͥ٤ѹ */
ER      get_pri(ID tskid, PRI *p_tskpri);					/* ͥ٤λ */
ER      ref_tsk(ID tskid, T_RTSK *p_rtsk);					/* ξֻ */
ER      ref_tst(ID tskid, T_RTST *p_rtst);					/* ξֻ(ʰ) */

/* °Ʊǽ */
ER      slp_tsk(void);										/* εԤ */
ER      tslp_tsk(TMO tmout);								/* εԤ(ॢȤ) */
ER      wup_tsk(ID tskid);									/* ε */
#define	iwup_tsk	wup_tsk									/* ε(󥿥ƥѥޥ) */
ER_UINT can_wup(ID tskid);									/* ׵Υ󥻥 */
ER      rel_wai(ID tskid);									/* Ԥ֤ζ */
#define	irel_wai	rel_wai									/* Ԥ֤ζ(󥿥ƥѥޥ) */
ER      sus_tsk(ID tskid);									/* Ԥ֤ؤΰܹ */
ER      rsm_tsk(ID tskid);									/* Ԥ֤κƳ */
ER      frsm_tsk(ID tskid);									/* Ԥ֤ζƳ */
ER      dly_tsk(RELTIM dlytim);								/* ٱ */

/* 㳰ǽ */
ER      ras_tex(ID tskid, TEXPTN rasptn);					/* 㳰׵ */
#define iras_tex	ras_tex									/* 㳰׵(󥿥ƥѥޥ) */
ER      dis_tex(void);										/* 㳰ζػ */
ER      ena_tex(void);										/* 㳰ζػ */
BOOL    sns_tex(void);										/* 㳰ػ߾֤λ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_tsk_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
