package jp.sourceforge.manganetwork;

import jp.sourceforge.manganetwork.page.BookRegistPage;
import jp.sourceforge.manganetwork.page.BookSearchPage;
import jp.sourceforge.manganetwork.page.HomePage;
import jp.sourceforge.manganetwork.page.LoginPage;
import jp.sourceforge.manganetwork.web.MyWebRequestCycleProcessor;
import jp.sourceforge.manganetwork.web.UserSession;

import org.apache.wicket.Request;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.HttpSessionStore;
import org.apache.wicket.request.IRequestCycleProcessor;
import org.apache.wicket.session.ISessionStore;
import org.jboss.webbeans.wicket.WebBeansApplication;

public class WicketApplication extends WebBeansApplication {

	public Class getHomePage() {
		return LoginPage.class;
	}

	@Override
	protected ISessionStore newSessionStore() {
		return new HttpSessionStore(this);
	}

	@Override
	public Session newSession(Request request, Response response) {
		return new UserSession(request);
	}

	@Override
	protected IRequestCycleProcessor newRequestCycleProcessor() {
		return new MyWebRequestCycleProcessor();
	}

	@Override
	protected void init() {
		super.init();
		setEncoding();
		getResourceSettings().setResourcePollFrequency(null);
		mountBookmarkablePage("/home", HomePage.class);
		mountBookmarkablePage("/booksearch", BookSearchPage.class);
		mountBookmarkablePage("/bookregist", BookRegistPage.class);
	}

	private void setEncoding() {
		getRequestCycleSettings().setResponseRequestEncoding("UTF-8");
		getMarkupSettings().setDefaultMarkupEncoding("UTF-8");
	}

}
