%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
  <title>Libtool-&libtool-version; 32 Bit Libraries</title>
@y
  <title>Libtool-&libtool-version; 32&Bit;ライブラリ</title>
@z

@x
    <secondary>32 Bit</secondary>
@y
    <secondary>32&Bit;</secondary>
@z

@x
    <title>Installation of Libtool</title>
@y
    <title>&InstallationOf1;Libtool &InstallationOf2;</title>
@z

@x
    <para os="a1">The following <filename>config.cache</filename> entry
    overrides the default search path, which does not take
    multilib into account:</para>
@y
    <para os="a1">
    以下のように <filename>config.cache</filename> ファイルに項目を加えてデフォルトの検索パスを設定します。
    マルチライブラリを考慮しないようにするものです。
    </para>
@z

@x
    <para os="e">To test the results, first identify whether you are on a big- or
    little-endian machine.  SGI machines are usually big-endian, Cobalt are
    usually little-endian.  If in doubt you can <command>echo ${MACHTYPE} | grep 'el-'
    </command>- this will match a little-endian machine.</para>
@y
    <para os="e">
    ビルド結果をテストする場合はまずマシンがビッグエンディアンかリトルエンディアンかを確認します。
    SGI マシンは通常ビッグエンディアン、Cobalt マシンはリトルエンディアンです。
    自信がないならば <command>echo ${MACHTYPE} | grep 'el-'</command> を実行してみてください。
    リトルエンディアンであれば出力があるはずです。
    </para>
@z

@x
    <para os="e2">To test on a little-endian machine issue:
    <userinput>make LDEMULATION=elf32ltsmip check</userinput>.</para>
@y
    <para os="e2">
    リトルエンディアンマシンの場合、テスト実行は <userinput>make LDEMULATION=elf32ltsmip check</userinput> とします。
    </para>
@z

@x
    <para os="e1">To test on a big-endian machine issue:
    <userinput>make LDEMULATION=elf32btsmip check</userinput>.</para>
@y
    <para os="e1">
    ビッグエンディアンマシンの場合、テスト実行は <userinput>make LDEMULATION=elf32btsmip check</userinput> とします。
    </para>
@z

@x
      <title>The meaning of the override on make check:</title>
@y
      <title>make check におけるオーバーライドの意味</title>
@z

@x LDEMULATION=[emulation]
        <term><parameter>LDEMULATION=[emulation]</parameter></term>
@y
        <term><parameter>LDEMULATION=[エミュレーション]</parameter></term>
@z
@x
          <para>Libtool tends to do the wrong thing when building for multilib,
          at least on the non-default size(s) of architecture.  The causes of
          these errors are not well understood and they can appear, or disappear,
          as a result of apparently innocuous other changes in the build.  In
          this version of the book, one of the tests (pdemo-make) fails to link
          because it tries to link the 32-bit objects against 64-bit system
          libraries. This option enables the test to succeed without impacting
          the other tests (compare the common alternative fixes of
          <literal>LD="gcc ${BUILD32}"</literal> which causes far fewer tests
          to be executed, and configuring with
          <literal>LDFLAGS='-L/lib -L/usr/lib'</literal> which in this case
          causes other tests to fail.)</para>
@y
          <para>
          Libtool はマルチライブラリのビルド時に、特にデフォルトサイズを持たないアーキテクチャーである場合に正常処理されません。
          エラーとなる原因はよく分かっていません。
          エラーが出たり出なかったりして、結局は意味のない修正に向かってしまいます。
          本書が今示す時点にて pdemo-make テストがリンクに失敗します。
          これは32ビットモジュールを64ビットシステムのライブラリにリンクしようとするためです。
          本オプションはエラーとなってしまうテストを成功させます。
          その他のテストには影響を及ぼしません。
          (ごく普通に行われる <literal>LD="gcc ${BUILD32}"</literal> の指定と比べてみると、この指定ではテストの成功率が格段に減ります。
          あるいは <literal>LDFLAGS='-L/lib -L/usr/lib'</literal> を指定したとすると、今度は他のテストが失敗します。)
          </para>
@z

@x
    <para os="m1">Prepare <filename>libtool</filename> to be wrapped by
    the multiarch wrapper. Libtool by itself is not multilib aware:</para>
@y
    <para os="m1">
    <filename>libtool</filename> を Multiarch Wrapper でラップするための用意をします。
    Libtool 自体はマルチライブラリ対応ではありません。
    </para>
@z

@x
    <para>Details on this package are located in <xref
    linkend="contents-libtool" role="."/></para>
@y
    <para>
    &Details1;<xref linkend="contents-libtool" role=""/>&Details2;
    </para>
@z