%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
    <para>The XZ Utils package contains programs for compressing and
    decompressing files. Compressing text files with <command>XZ Utils</command>
    yields a much better compression percentage than with the traditional
    <command>gzip</command>.</para>
@y
    <para>
    XZ Utils パッケージは、ファイルの圧縮、伸張 (解凍) を行うプログラムを提供します。
    <command>XZ Utils</command> によりテキストファイルを圧縮すると、従来の <command>gzip</command> に比べて高い圧縮率を実現できます。
    </para>
@z

@x
    <title>Installation of XZ Utils</title>
@y
    <title>&InstallationOf1;XZ Utils &InstallationOf2;</title>
@z

@x
    <para os="a">Prepare XZ Utils for compilation:</para>
@y
    <para os="a">&PreparePackage1;XZ Utils &PreparePackage2;</para>
@z

@x
    <para os="c">Compile the package:</para>
@y
    <para os="c">&CompileThePackage;</para>
@z

@x
    <para os="e">To test the results, issue:</para>
@y
    <para os="e">
    ビルド結果をテストする場合は以下を実行します。
    </para>
@z

@x
    <para os="f">Install the programs:</para>
@y
    <para os="f">&InstallThePackage;</para>
@z

@x
    <para os="h">Move the <filename>xz</filename> binary, and several symlinks
    that point to it, into the /bin directory:</para>
@y
    <para os="h">
    <filename>xz</filename> バイナリとこれに対するシンボリックリンクを /bin ディレクトリに移動させます。
    </para>
@z

@x
    <para os="j">Finally, move the shared library to a more appropriate
    location, and recreate the symlink pointing to it:</para>
@y
    <para os="j">
    最後に共有ライブラリを適切なディレクトリに移動させます。
    そしてそれに対するシンボリックリンクを再生成します。
    </para>
@z

@x
    <title>Contents of XZ Utils</title>
@y
    <title>&ContentsOf1;XZ Utils &ContentsOf2;</title>
@z

@x
      <segtitle>Installed programs</segtitle>
      <segtitle>Installed libraries</segtitle>
      <segtitle>Installed directories</segtitle>
@y
      <segtitle>&InstalledProgram;</segtitle>
      <segtitle>&InstalledLibrary;</segtitle>
      <segtitle>&InstalledDirectory;</segtitle>
@z

@x
        <seg>lzcat (link to xz), lzcmp (link to xzdiff), lzdiff (link to
        xzdiff), lzegrep (link to xzgrep), lzfgrep (link to xzgrep), lzgrep
        (link to xzgrep), lzless (link to xzless), lzma (link to xz), lzmadec,
        lzmainfo, lzmore (link to xzmore), unlzma (link to xz), unxz (link to
        xz), xz, xzcat (link to xz), xzcmp (link to xzdiff), xzdec, xzdiff,
        xzegrep (link to xzgrep), xzfgrep (link to xzgrep), xzgrep, xzless,
        xzmore</seg>
        <seg>liblzma.[a,so]</seg>
        <seg>/usr/include/lzma, /usr/share/doc/xz-&xz-version;</seg>
@y
        <seg>lzcat (&LinkTo1;xz &LinkTo2;), lzcmp (&LinkTo1;xzdiff &LinkTo2;),
        lzdiff (&LinkTo1;xzdiff &LinkTo2;), lzegrep (&LinkTo1;xzgrep &LinkTo2;),
        lzfgrep (&LinkTo1;xzgrep &LinkTo2;), lzgrep (&LinkTo1;xzgrep &LinkTo2;),
        lzless (&LinkTo1;xzless &LinkTo2;), lzma (&LinkTo1;xz &LinkTo2;), lzmadec,
        lzmainfo, lzmore (&LinkTo1;xzmore &LinkTo2;), unlzma (&LinkTo1;xz &LinkTo2;),
        unxz (&LinkTo1;xz &LinkTo2;), xz, xzcat (&LinkTo1;xz &LinkTo2;),
        xzcmp (&LinkTo1;xzdiff &LinkTo2;), xzdec, xzdiff,
        xzegrep (&LinkTo1;xzgrep &LinkTo2;), xzfgrep (&LinkTo1;xzgrep &LinkTo2;),
        xzgrep, xzless,
        xzmore</seg>
        <seg>liblzma.[a,so]</seg>
        <seg>/usr/include/lzma, /usr/share/doc/xz-&xz-version;</seg>
@z

@x
      <bridgehead renderas="sect3">Short Descriptions</bridgehead>
@y
      <bridgehead renderas="sect3">&ShortDescriptions;</bridgehead>
@z

@x lzcat
          <para>Decompresses LZMA and xz files</para>
@y
          <para>ファイルを伸張 (解凍) し標準出力へ出力します。</para>
@z

@x lzcmp
          <para>Compares lzma compressed files</para>
@y
          <para>lzma 圧縮されたファイルに対して <command>cmp</command> を実行します。</para>
@z

@x lzdiff
          <para>Compares lzma compressed files</para>
@y
          <para>lzma 圧縮されたファイルに対して <command>diff</command> を実行します。</para>
@z

@x lzegrep
          <para>Runs <command>egrep</command> on lzma compressed files</para>
@y
          <para>lzma 圧縮されたファイルに対して <command>egrep</command> を実行します。</para>
@z

@x lzfgrep
          <para>Runs <command>fgrep</command> on lzma compressed files</para>
@y
          <para>lzma 圧縮されたファイルに対して <command>fgrep</command> を実行します。</para>
@z

@x lzgrep
          <para>Runs <command>grep</command> on lzma compressed files</para>
@y
          <para>lzma 圧縮されたファイルに対して <command>grep</command> を実行します。</para>
@z

@x lzless
          <para>Runs <command>less</command> on lzma files</para>
@y
          <para>lzma 圧縮されたファイルに対して <command>less</command> を実行します。</para>
@z

@x lzma
          <para>Compresses lzma files</para>
@y
          <para>lzma フォーマットによりファイルの圧縮と伸張 (解凍) を行います。</para>
@z

@x lzmadec
          <para>Decompresses lzma files</para>
@y
          <para>lzma 圧縮されたファイルを高速に伸張 (解凍) するコンパクトなプログラムです。</para>
@z

@x lzmainfo
          <para>Displays information stored in an .lzma file header</para>
@y
          <para>.lzma ファイルヘッダーに保持されている情報を表示します。</para>
@z

@x lzmore
          <para>Runs <command>more</command> on lzma files</para>
@y
          <para>lzma 圧縮されたファイルに対して <command>more</command> を実行します。</para>
@z

@x unlzma
          <para>Uncompresses lzma files</para>
@y
          <para>lzma フォーマットされたファイルを伸張 (解凍) します。</para>
@z

@x unxz
          <para>Uncompresses xz files</para>
@y
          <para>xz フォーマットされたファイルを伸張 (解凍) します。</para>
@z

@x xz
          <para>Creates xz compressed files</para>
@y
          <para>xz フォーマットによりファイルの圧縮と伸張 (解凍) を行います。</para>
@z

@x xzcat
          <para>Decompresses xz files</para>
@y
          <para>ファイルの伸張 (解凍) を行い標準出力へ出力します。</para>
@z

@x xzcmp
          <para>Compares xz compressed files</para>
@y
          <para>
          xz により圧縮されたファイルを比較します。
          </para>
@z

@x xzdec
          <para>Decompresses to standard output</para>
@y
          <para>xz 圧縮されたファイルを高速に伸張 (解凍) するコンパクトなプログラムです。</para>
@z

@x xzdiff
          <para>Compares xz compressed files</para>
@y
          <para>xz 圧縮されたファイルに対して <command>diff</command> を実行します。</para>
@z

@x xzegrep
          <para>Runs <command>egrep</command> on xz compressed files</para>
@y
          <para>xz 圧縮されたファイルに対して <command>egrep</command> を実行します。</para>
@z

@x xzfgrep
          <para>Runs <command>fgrep</command> on xz compressed files</para>
@y
          <para>xz 圧縮されたファイルに対して <command>fgrep</command> を実行します。</para>
@z

@x xzgrep
          <para>Runs <command>grep</command> on xz compressed files</para>
@y
          <para>xz 圧縮されたファイルに対して <command>grep</command> を実行します。</para>
@z

@x xzless
          <para>Runs <command>less</command> on xz files</para>
@y
          <para>xz 圧縮されたファイルに対して <command>less</command> を実行します。</para>
@z

@x xzmore
          <para>Runs <command>more</command> on xz files</para>
@y
          <para>xz 圧縮されたファイルに対して <command>more</command> を実行します。</para>
@z

@x liblzma
          <para>The LZMA library</para>
@y
          <para>LZMA ライブラリ。</para>
@z