%
% This is part of CLFSja package.
%
% This is a CTIE change file for the original XML source of the CLFSbook.
%
@x
<?xml version="1.0" encoding="ISO-8859-1"?>
@y
<?xml version="1.0" encoding="UTF-8"?>
@z

@x
<appendix id="appendixd-common" xreflabel="Appendix D">
@y
<appendix id="appendixd-common" xreflabel="付録D">
@z

@x
  <title>Package Rationale</title>
@y
  <title>各パッケージを用いる理由</title>
@z

@x
  <para>CLFS includes many packages, a number of which might not necessarily
  be required for a "minimal" system, but still considered very useful. The
  purpose of this page is to list the reasoning for each package's inclusion
  in the book.</para>
@y
  <para>
  CLFS には実に多くのパッケージが含まれます。
  "最小" システムにとっては絶対に必要と言えないものもありますが、それでも有用なパッケージには違いありません。
  以下に示す一覧は、本書内の各パッケージの採用根拠について説明するものです。
  </para>
@z

@x Autoconf
      <para>The Autoconf package contains programs for producing shell scripts
      that can automatically configure source code. This is useful for software
      developers, as well as anyone who wants to install packages that don't
      come with a configure script, such as some of the packages in CBLFS.</para>
@y
      <para>
      Autoconf パッケージは、ソースコードを自動的に設定する (configure する) ためのシェルスクリプトを生成するプログラムを提供します。
      ソフトウェア開発者にとって有用なパッケージです。
      パッケージによっては configure スクリプトが含まれていないものも CBLFS の中にはあります。
      そういったパッケージをインストールする者にとっても有用なものです。
      </para>
@z

@x Automake
      <para>The Automake package contains programs for generating Makefiles
      for use with Autoconf. This can be useful to software developers.</para>
@y
      <para>
      Automake パッケージは、Autoconf と併用して Makefile を生成するためのプログラムを提供します。
      ソフトウェア開発者にとって有用なパッケージです。
      </para>
@z

@x Bash
      <para>This package contains the Bourne-Again SHell. A shell is an
      important component of a Linux system, as there must be some way of
      allowing the users to enter commands.</para>
@y
      <para>
      このパッケージは Bourne-Again SHell を提供します。
      シェルというものは Linux システムにとって重要なものです。
      ユーザーからのコマンド入力を受け入れます。
      </para>
@z

@x Bc
      <para>This package contains a precision calculator. The Linux kernel
      uses Bc to render the timeconst header.</para>
@y
      <para>
      このパッケージは精度演算処理を提供します。
      Linux カーネルはこのパッケージを用いて timeconst ヘッダーを提供します。
      </para>
@z

@x Binutils
      <para>This package contains programs for handling object files. The
      programs in this package are needed for compiling most of the packages
      in CLFS.</para>
@y
      <para>
      このパッケージはオブジェクトファイルを取り扱うプログラムを提供します。
      CLFS におけるパッケージのコンパイルには、必ずといってよいほど本パッケージのプログラムを利用します。
      </para>
@z

@x Bison
      <para>This package contains programs that are required by several
      packages in CLFS.</para>
@y
      <para>
      本パッケージは、いくつかの CLFS パッケージにおいて必要となるプログラムを提供します。
      </para>
@z

@x Bzip2
      <para>The programs in this package are useful for compressing files to
      reduce size. They are also needed to uncompress tarballs for many
      CLFS packages.</para>
@y
      <para>
      このパッケージが提供するプログラムはファイルを圧縮してサイズ縮小する有用なものです。
      また CLFS パッケージの tarball を伸張 (解凍) する際にも用います。
      </para>
@z

@x CLFS-Boot-scripts
      <para>This package contains a number of scripts that run at boottime,
      performing essential tasks such as mounting/checking filesystems and
      starting the network interface.</para>
@y
      <para>
      このパッケージはシステム起動時に実行するスクリプトを数多く提供します。
      ファイルシステムのマウントやチェック、ネットワークインターフェースの起動などの基本的なタスクを実現します。
      </para>
@z

@x Check
      <para>This package contains a test harness for other programs. It is
      used for some packages' test suites.</para>
@y
        <para>
        このパッケージは、他のプログラムに対するテストハーネス (test harness) を提供します。
        テストスイートの実行のためにこれを必要とするパッケージがあります。
        </para>
@z

@x Coreutils
      <para>This package contains many basic command-line file-management
      tools, required for installation of every package in CLFS.</para>
@y
      <para>
      このパッケージはファイル操作を行う基本的なコマンドラインプログラムを多く提供します。
      CLFS のすべてのパッケージのインストールにて必要となります。
      </para>
@z

@x DejaGNU
      <para>This package is needed for the test suites of several packages,
      especially GCC and Binutils.</para>
@y
      <para>
      このパッケージはテストスイート実行のために必要としているパッケージがあります。
      特に GCC と Binutils はこれを必要としています。
      </para>
@z

@x DHCPCD
      <para>This package allows for automatic configuration of network
      interfaces from a DHCP server. It (or some other package providing a
      DHCP client is needed to connect to a DHCP server.</para>
@y
      <para>
      このパッケージは DHCP サーバーからネットワークインターフェース情報を自動的に設定する機能を実現します。
      DHCP サーバーに接続するためには DHCP クライアントが必要です。
      </para>
@z

@x Diffutils
      <para>This package contains programs to compare files, and can also
      be used to create patches. It is required by the installation procedures
      of many CLFS packages, and used by many packages' test suites.</para>
@y
      <para>
      このパッケージはファイル同士の比較、あるいはパッチの生成を実現します。
      CLFS パッケージのインストール時にこれを必要とするものが多くあります。
      あるいはテストスイートの実行に必要とするものもあります。
      </para>
@z

@x Eudev
      <para>This is a package that allows for dynamic creation of device nodes.
      It is a fork of Udev, which is now part of Systemd. It is still
      used for the "Boot" method in the temp-system, as Systemd is not needed
      there.</para>
@y
      <para>
      このパッケージはデバイスノードの動的生成機能を提供します。
      Udev からフォークしたものであり、現在は Systemd の一部に取り込まれています。
      一時システム内でのシステム起動方式に用いるもので、その段階ではまだ Systemd が不要であるためです。
      </para>
@z

@x Expect
      <para>This package is needed for the test suites for several packages.</para>
@y
      <para>
      このパッケージはテストスイートの実行に必要としているパッケージがあります。
      </para>
@z

@x E2fsprogs
      <para>The programs in this package are used for the creation and
      maintenance of ext2/3/4 filesystems.</para>
@y
      <para>
      このパッケージが提供するプログラムにより ext2/3/4 ファイルシステムの生成と保守を行うことができます。
      </para>
@z

@x File
      <para>This package contains a program that determines the type of
      a given file. It is needed by some CLFS packages.</para>
@y
        <para>
        このパッケージは、指定されたファイルの種類を判別するプログラムを提供します。
        CLFS パッケージの中にこれを必要とするものがあります。
        </para>
@z

@x Findutils
      <para>This package contains programs for finding files based on certain
      criteria, and optionally performing commands on them. These programs
      are used by the installation procedures of many CLFS packages.</para>
@y
      <para>
      このパッケージは、特定の検索基準に基づいてファイルを検索するプログラムを提供します。
      CLFS パッケージのインストール手順にて多用されています。
      </para>
@z

@x Flex
      <para>This package contains a tool for generating text scanners. It is
      used by multiple packages in CLFS</para>
@y
      <para>
      このパッケージはテキスト走査を実現するツールを提供します。
      CLFS パッケージの中にこれを用いているものがあります。
      </para>
@z

@x Gawk
      <para>This package contains programs for manipulating text files, using
      the AWK language. It is used by the installation procedures of many
      packages in CLFS.</para>
@y
      <para>
      このパッケージは AWK 言語を用いてテキストファイルを操作するプログラムを提供します。
      CLFS パッケージのインストール手順にて多用されています。
      </para>
@z

@x Gcc
      <para>This package contains a C compiler, which is required to compile
      most of the packages in CLFS.</para>
@y
      <para>
      このパッケージは C コンパイラーを提供します。
      CLFS パッケージをコンパイルするのにたいていは必要となります。
      </para>
@z

@x GDBM
      <para>This package contains the GNU Database Manager library. Man-DB
      requires either GDBM or Berkeley DB, though it prefers GDBM.</para>
@y
      <para>
      このパッケージは GNU データベースマネージャーライブラリを提供します。
      Man-DB パッケージが GDBM あるいは Berkeley DB を必要としており、GDBM の方が適切なものです。
      </para>
@z

@x Gettext
      <para>A tool that allows programmers to easily implement i18n
      (internationalization) in their programs. It is a required dependency
      for a number of packages</para>
@y
      <para>
      プログラム開発者が i18n (国際化) 対応を用意にできるツールです。
      他パッケージの多くがこれに依存しています。
      </para>
@z

@x Glibc
      <para>Any dynamically-linked C program (nearly every package in CLFS
      has these) needs a C library to compile and run.</para>
@y
      <para>
      動的リンクの C プログラム (ほぼすべての CLFS パッケージ) がコンパイルおよび実行に必要としている C ライブラリです。
      </para>
@z

@x GMP
      <para>This package is required by GCC.</para>
@y
      <para>
      GCC が本パッケージを必要としています。
      </para>
@z

@x Grep
      <para>This package contains programs for searching for text in files.
      These programs are required by many packages in CLFS.</para>
@y
      <para>
      このパッケージはファイル内のテキストを検索するプログラムを提供します。
      CLFS パッケージの多くがこれを必要としています。
      </para>
@z

@x Groff
      <para>This package is required by Man-DB.</para>
@y
      <para>
      Man-DB が本パッケージを必要としています。
      </para>
@z

@x Gzip
      <para>Useful for compressing files to reduce size. It is also needed to
      uncompress tarballs for many CLFS packages</para>
@y
      <para>
      このパッケージが提供するプログラムはファイルを圧縮してサイズ縮小する有用なものです。
      また CLFS パッケージの tarball を伸張 (解凍) する際にも用います。
      </para>
@z

@x Iana-Etc
      <para>This package provides the <filename>/etc/services</filename> and
      <filename>/etc/protocols</filename> files. These files map port names to
      port numbers as well as protocol names to their corresponding numbers.
      These files are essential for many network based programs to work properly.</para>
@y
      <para>
      このパッケージは <filename>/etc/services</filename> ファイルと <filename>/etc/protocols</filename> ファイルを提供します。
      このファイルはポート名をポート番号にマッピングさせ、またプロトコル名を対応する番号にマッピングさせます。
      ネットワーク関連のプログラムを正常動作させるためにはこのファイルが必要となります。
      </para>
@z

@x IProute2
      <para>This package contains programs for administering network
      interfaces.</para>
@y
      <para>
      このパッケージはネットワークインターフェースを管理するプログラムを提供します。
      </para>
@z

@x IPutils
      <para>This package contains several basic network-management tools.</para>
@y
      <para>
      このパッケージは基本的なネットワーク管理ツールを提供します。
      </para>
@z

@x ISL
      <para>This package is required by GCC for GRAPHITE optimizations.</para>
@y
      <para>
      本パッケージは GCC の GRAPHITE 最適化に必要です。
      </para>
@z

@x Kbd
      <para>Contains keytable files and keyboard utilities compatible with the
      Linux kernel. These can be used to change the display font and keyboard
      layout.</para>
@y
      <para>
      Linux カーネルと互換性のあるキーテーブルファイルやキーボードユーティリティーを提供します。
      ディスプレイフォントやキーボードレイアウトの設定にも利用されます。
      </para>
@z

@x Kmod
      <para>This package contains programs that assist in loading an unloading
      kernel modules.</para>
@y
      <para>
      このパッケージはカーネルモジュールのロード、アンロードをサポートするプログラムを提供します。
      </para>
@z

@x Less
      <para>A program that lets you view text files one page at a time.
      It is also used by Man-DB for displaying manpages.</para>
@y
      <para>
      テキストファイルを１ページずつ表示するプログラムです。
      Man-DB において man ページを表示する際にも用いられます。
      </para>
@z

@x Libee
      <para>This library is required by Rsyslog.</para>
@y
      <para>
      このライブラリは Rsyslog が必要としています。
      </para>
@z

@x Libpipeline
      <para>The Libpipeline package contains a library for manipulating
      pipelines of subprocesses in a flexible and convenient way. It is
      required by the Man-DB package.</para>
@y
      <para>
      Libpipeline パッケージは柔軟かつ便利にサブプロセスのパイプラインを制御するライブラリを提供します。
      Man-DB パッケージがこれを必要としています。
      </para>
@z

@x Libtool
      <para>The Libtool package contains the GNU generic library support
      script. It is used by some CLFS packages.</para>
@y
      <para>
      Libtool パッケージは GNU 汎用ライブラリをサポートするスクリプトを提供します。
      CLFS パッケージの中にこれを用いるものがあります。
      </para>
@z

@x Linux Headers
      <para>Linux Headers</para>
      <para>This package consists of santized headers from the Linux Kernel.
      These headers are required for Glibc to compile.</para>
@y
      <para>Linux ヘッダー</para>
      <para>
      このパッケージは健全化 (sanitized) された Linux カーネルヘッダーを提供します。
      ヘッダーは Glibc のコンパイルに必要です。
      </para>
@z

@x Linux Kernel
      <para>Linux Kernel</para>
      <para>The Linux operating system.</para>
@y
      <para>Linux カーネル</para>
      <para>
      Linux オペレーティングシステム。
      </para>
@z

@x M4
      <para>This package contains a macro processor. It is required by several
      CLFS packages, including Bison.</para>
@y
      <para>
      このパッケージはマクロプロセッサーを提供します。
      Bison などのように CLFS パッケージにてこれを用いるものがあります。
      </para>
@z

@x Make
      <para>This is required for installation of most CLFS packages</para>
@y
      <para>
      CLFS パッケージのインストールにおいて、たいてい必要となります。
      </para>
@z

@x Man-DB
      <para>This package contains programs for finding and viewing man pages,
      and has superior internationalization capabilities compared to the
      <application>Man</application> package.</para>
@y
      <para>
      このパッケージは man ページを検索し表示するプログラムを提供します。
      <application>Man</application> パッケージに比べて国際化対応に優れています。
      </para>
@z

@x Man-Pages
      <para>A number of useful manpages, not supplied by other packages</para>
@y
      <para>
      他のパッケージからは提供されない、有用で豊富な man ページを提供します。
      </para>
@z

@x MPC
      <para>This package is required by GCC.</para>
@y
      <para>
      GCC が本パッケージを必要としています。
      </para>
@z

@x MPFR
      <para>This package is required by GCC.</para>
@y
      <para>
      GCC が本パッケージを必要としています。
      </para>
@z

@x Ncurses
      <para>Needed by several packages in CLFS, such as Vim, Bash, and Less</para>
@y
      <para>
      Vim, Bash, Less などのように CLFS パッケージにてこれを用いるものがあります。
      </para>
@z

@x Patch
      <para>Used for applying patches in several CLFS packages</para>
@y
      <para>
      CLFS パッケージにてパッチを適用するために用いられます。
      </para>
@z

@x Perl
      <para>The Perl package contains the Practical Extraction and Report
      Language. It is required by several CLFS packages.</para>
@y
      <para>
      Perl パッケージは Perl 言語 (Practical Extraction and Report Language) を提供します。
      </para>
@z

@x Pkg-config-lite
      <para>Several packages in CLFS, and many others outside of CLFS,
      use <command>pkg-config</command> to locate dependencies.</para>
@y
      <para>
      CLFS パッケージにおいて、あるいは CLFS で取り扱っていないパッケージにおいて <command>pkg-config</command> を用いて依存パッケージを検出します。
      </para>
@z

@x Procps-ng
      <para>Provides a number of small, useful utilities that give information
      about the <filename class="directory">/proc</filename> filesystem.</para>
@y
      <para>
      <filename class="directory">/proc</filename> ファイルシステムに関する情報を提供する有用なユーティリティーを提供します。
      </para>
@z

@x Psmisc
      <para>Provides more utilties that give information about the
      <filename class="directory">/proc</filename> filesystem.</para>
@y
      <para>
      <filename class="directory">/proc</filename> ファイルシステムに関する情報を提供する更なるユーティリティーを提供します。
      </para>
@z

@x Readline
      <para>The Readline library provides a set of functions for use by
      applications that allow users to edit command lines as they are typed
      in. This is essential for input in programs like <command>bash</command>
      to work properly.</para>
@y
      <para>
      Readline ライブラリはコマンドライン上での入力編集を行うアプリケーションに用いられる関数を提供します。
      これは <command>bash</command> のようなプログラムにおける入力機能を正常動作させるために必要です。
      </para>
@z

@x Sed
      <para>This package contains a stream editor. It is used in the
      installation procedures of most CLFS packages.</para>
@y
      <para>
      このパッケージはストリームエディターを提供します。
      CLFS パッケージのインストール手順においてたいてい必要となります。
      </para>
@z

@x Shadow
      <para>This package contains programs that assist in the administration
      of users and groups, and passwords.</para>
@y
      <para>
      このパッケージはユーザー、グループ、そのパスワードの管理をサポートするプログラムを提供します。
      </para>
@z

@x Sysvinit
      <para>Sysvinit provides the init daemon for the system.</para>
@y
      <para>
      Sysvinit は Init デーモンを提供します。
      </para>
@z

@x Tar
      <para>Required to unpack the tar archives in which all CLFS packages
      are distributed</para>
@y
      <para>
      CLFS パッケージにて提供されているアーカイブを伸長 (解凍) するために必要です。
      </para>
@z

@x Tcl
      <para>Needed for the test suites of several packages</para>
@y
      <para>
      パッケージのテストスイートよってはこれを必要とするものがあります。
      </para>
@z

@x Texinfo
      <para>This package contains programs for viewing, installing and
      converting info pages. It is used in the installation procedures
      of many CLFS packages.</para>
@y
      <para>
      このパッケージは info ページの参照、インストール、変換を行うプログラムを提供します。
      CLFS パッケージの多くはインストール時にこれを利用しています。
      </para>
@z

@x Util-linux
      <para>The Util-linux package contains miscellaneous utility programs.
      Among them are utilities for handling file systems, consoles,
      partitions, and messages. It also includes libraries that are required
      by E2fsprogs.</para>
@y
      <para>
      Util-linux パッケージはユーティリティープログラムを数多く提供します。
      その中には、ファイルシステムやコンソール、パーティション、メッセージなどを取り扱うユーティリティがあります。
      またここに含まれるライブラリは E2fsprogs が必要としています。
      </para>
@z

@x Vim
      <para>The Vim package contains a text editor. Users may substitute Nano,
      Joe, Emacs, or whatever other editor they prefer.</para>
@y
      <para>
      Vim パッケージはテキストエディターです。
      他のエディターを用いたい場合は Nano, Joe, Emacs などを採用してください。
      </para>
@z

@x XZ Utils
      <para>Useful for compressing files to reduce size. Also needed to
      uncompress tarballs for many CLFS packages</para>
@y
      <para>
      ファイルを圧縮してサイズ縮小する有用なプログラムです。
      また CLFS パッケージの tarball を伸張 (解凍) する際にも用います。
      </para>
@z

@x Zlib
      <para>The Zlib package contains compression and decompression routines
      used by some programs.</para>
@y
      <para>
      Zlib パッケージは圧縮、伸張 (解凍) ルーチンを提供します。
      特定のプログラムがこれを用いています。
      </para>
@z