/*-----------------------------------------------------------------------------
 * File: option.cpp
 *-----------------------------------------------------------------------------
 * Copyright (c) 2004-2005  Kazuo Ishii <k-ishii@wb4.so-net.ne.jp>
 *				- original version
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
#include "option.h"
#include "version.h"
#include <shlwapi.h>

static bool lookupColor(const char *str, COLORREF& ret)
{
	typedef struct {
		COLORREF	color;
		char		*name;
	} COLOR;
	static const COLOR colors[] = {
		{ RGB(0xF0,0xF8,0xFF), "alice blue" },
		{ RGB(0xF0,0xF8,0xFF), "AliceBlue" },
		{ RGB(0xFA,0xEB,0xD7), "antique white" },
		{ RGB(0xFA,0xEB,0xD7), "AntiqueWhite" },
		{ RGB(0xFF,0xEF,0xDB), "AntiqueWhite1" },
		{ RGB(0xEE,0xDF,0xCC), "AntiqueWhite2" },
		{ RGB(0xCD,0xC0,0xB0), "AntiqueWhite3" },
		{ RGB(0x8B,0x83,0x78), "AntiqueWhite4" },
		{ RGB(0x7F,0xFF,0xD4), "aquamarine" },
		{ RGB(0x7F,0xFF,0xD4), "aquamarine1" },
		{ RGB(0x76,0xEE,0xC6), "aquamarine2" },
		{ RGB(0x66,0xCD,0xAA), "aquamarine3" },
		{ RGB(0x45,0x8B,0x74), "aquamarine4" },
		{ RGB(0xF0,0xFF,0xFF), "azure" },
		{ RGB(0xF0,0xFF,0xFF), "azure1" },
		{ RGB(0xE0,0xEE,0xEE), "azure2" },
		{ RGB(0xC1,0xCD,0xCD), "azure3" },
		{ RGB(0x83,0x8B,0x8B), "azure4" },
		{ RGB(0xF5,0xF5,0xDC), "beige" },
		{ RGB(0xFF,0xE4,0xC4), "bisque" },
		{ RGB(0xFF,0xE4,0xC4), "bisque1" },
		{ RGB(0xEE,0xD5,0xB7), "bisque2" },
		{ RGB(0xCD,0xB7,0x9E), "bisque3" },
		{ RGB(0x8B,0x7D,0x6B), "bisque4" },
		{ RGB(0x00,0x00,0x01), "black" },
		{ RGB(0xFF,0xEB,0xCD), "blanched almond" },
		{ RGB(0xFF,0xEB,0xCD), "BlanchedAlmond" },
		{ RGB(0x00,0x00,0xFF), "blue" },
		{ RGB(0x8A,0x2B,0xE2), "blue violet" },
		{ RGB(0x00,0x00,0xFF), "blue1" },
		{ RGB(0x00,0x00,0xEE), "blue2" },
		{ RGB(0x00,0x00,0xCD), "blue3" },
		{ RGB(0x00,0x00,0x8B), "blue4" },
		{ RGB(0x8A,0x2B,0xE2), "BlueViolet" },
		{ RGB(0xA5,0x2A,0x2A), "brown" },
		{ RGB(0xFF,0x40,0x40), "brown1" },
		{ RGB(0xEE,0x3B,0x3B), "brown2" },
		{ RGB(0xCD,0x33,0x33), "brown3" },
		{ RGB(0x8B,0x23,0x23), "brown4" },
		{ RGB(0xDE,0xB8,0x87), "burlywood" },
		{ RGB(0xFF,0xD3,0x9B), "burlywood1" },
		{ RGB(0xEE,0xC5,0x91), "burlywood2" },
		{ RGB(0xCD,0xAA,0x7D), "burlywood3" },
		{ RGB(0x8B,0x73,0x55), "burlywood4" },
		{ RGB(0x5F,0x9E,0xA0), "cadet blue" },
		{ RGB(0x5F,0x9E,0xA0), "CadetBlue" },
		{ RGB(0x98,0xF5,0xFF), "CadetBlue1" },
		{ RGB(0x8E,0xE5,0xEE), "CadetBlue2" },
		{ RGB(0x7A,0xC5,0xCD), "CadetBlue3" },
		{ RGB(0x53,0x86,0x8B), "CadetBlue4" },
		{ RGB(0x7F,0xFF,0x00), "chartreuse" },
		{ RGB(0x7F,0xFF,0x00), "chartreuse1" },
		{ RGB(0x76,0xEE,0x00), "chartreuse2" },
		{ RGB(0x66,0xCD,0x00), "chartreuse3" },
		{ RGB(0x45,0x8B,0x00), "chartreuse4" },
		{ RGB(0xD2,0x69,0x1E), "chocolate" },
		{ RGB(0xFF,0x7F,0x24), "chocolate1" },
		{ RGB(0xEE,0x76,0x21), "chocolate2" },
		{ RGB(0xCD,0x66,0x1D), "chocolate3" },
		{ RGB(0x8B,0x45,0x13), "chocolate4" },
		{ RGB(0xFF,0x7F,0x50), "coral" },
		{ RGB(0xFF,0x72,0x56), "coral1" },
		{ RGB(0xEE,0x6A,0x50), "coral2" },
		{ RGB(0xCD,0x5B,0x45), "coral3" },
		{ RGB(0x8B,0x3E,0x2F), "coral4" },
		{ RGB(0x64,0x95,0xED), "cornflower blue" },
		{ RGB(0x64,0x95,0xED), "CornflowerBlue" },
		{ RGB(0xFF,0xF8,0xDC), "cornsilk" },
		{ RGB(0xFF,0xF8,0xDC), "cornsilk1" },
		{ RGB(0xEE,0xE8,0xCD), "cornsilk2" },
		{ RGB(0xCD,0xC8,0xB1), "cornsilk3" },
		{ RGB(0x8B,0x88,0x78), "cornsilk4" },
		{ RGB(0x00,0xFF,0xFF), "cyan" },
		{ RGB(0x00,0xFF,0xFF), "cyan1" },
		{ RGB(0x00,0xEE,0xEE), "cyan2" },
		{ RGB(0x00,0xCD,0xCD), "cyan3" },
		{ RGB(0x00,0x8B,0x8B), "cyan4" },
		{ RGB(0xB8,0x86,0x0B), "dark goldenrod" },
		{ RGB(0x00,0x64,0x00), "dark green" },
		{ RGB(0xBD,0xB7,0x6B), "dark khaki" },
		{ RGB(0x55,0x6B,0x2F), "dark olive green" },
		{ RGB(0xFF,0x8C,0x00), "dark orange" },
		{ RGB(0x99,0x32,0xCC), "dark orchid" },
		{ RGB(0xE9,0x96,0x7A), "dark salmon" },
		{ RGB(0x8F,0xBC,0x8F), "dark sea green" },
		{ RGB(0x48,0x3D,0x8B), "dark slate blue" },
		{ RGB(0x2F,0x4F,0x4F), "dark slate gray" },
		{ RGB(0x2F,0x4F,0x4F), "dark slate grey" },
		{ RGB(0x00,0xCE,0xD1), "dark turquoise" },
		{ RGB(0x94,0x00,0xD3), "dark violet" },
		{ RGB(0xB8,0x86,0x0B), "DarkGoldenrod" },
		{ RGB(0xFF,0xB9,0x0F), "DarkGoldenrod1" },
		{ RGB(0xEE,0xAD,0x0E), "DarkGoldenrod2" },
		{ RGB(0xCD,0x95,0x0C), "DarkGoldenrod3" },
		{ RGB(0x8B,0x65,0x08), "DarkGoldenrod4" },
		{ RGB(0x00,0x64,0x00), "DarkGreen" },
		{ RGB(0xBD,0xB7,0x6B), "DarkKhaki" },
		{ RGB(0x55,0x6B,0x2F), "DarkOliveGreen" },
		{ RGB(0xCA,0xFF,0x70), "DarkOliveGreen1" },
		{ RGB(0xBC,0xEE,0x68), "DarkOliveGreen2" },
		{ RGB(0xA2,0xCD,0x5A), "DarkOliveGreen3" },
		{ RGB(0x6E,0x8B,0x3D), "DarkOliveGreen4" },
		{ RGB(0xFF,0x8C,0x00), "DarkOrange" },
		{ RGB(0xFF,0x7F,0x00), "DarkOrange1" },
		{ RGB(0xEE,0x76,0x00), "DarkOrange2" },
		{ RGB(0xCD,0x66,0x00), "DarkOrange3" },
		{ RGB(0x8B,0x45,0x00), "DarkOrange4" },
		{ RGB(0x99,0x32,0xCC), "DarkOrchid" },
		{ RGB(0xBF,0x3E,0xFF), "DarkOrchid1" },
		{ RGB(0xB2,0x3A,0xEE), "DarkOrchid2" },
		{ RGB(0x9A,0x32,0xCD), "DarkOrchid3" },
		{ RGB(0x68,0x22,0x8B), "DarkOrchid4" },
		{ RGB(0xE9,0x96,0x7A), "DarkSalmon" },
		{ RGB(0x8F,0xBC,0x8F), "DarkSeaGreen" },
		{ RGB(0xC1,0xFF,0xC1), "DarkSeaGreen1" },
		{ RGB(0xB4,0xEE,0xB4), "DarkSeaGreen2" },
		{ RGB(0x9B,0xCD,0x9B), "DarkSeaGreen3" },
		{ RGB(0x69,0x8B,0x69), "DarkSeaGreen4" },
		{ RGB(0x48,0x3D,0x8B), "DarkSlateBlue" },
		{ RGB(0x2F,0x4F,0x4F), "DarkSlateGray" },
		{ RGB(0x97,0xFF,0xFF), "DarkSlateGray1" },
		{ RGB(0x8D,0xEE,0xEE), "DarkSlateGray2" },
		{ RGB(0x79,0xCD,0xCD), "DarkSlateGray3" },
		{ RGB(0x52,0x8B,0x8B), "DarkSlateGray4" },
		{ RGB(0x2F,0x4F,0x4F), "DarkSlateGrey" },
		{ RGB(0x00,0xCE,0xD1), "DarkTurquoise" },
		{ RGB(0x94,0x00,0xD3), "DarkViolet" },
		{ RGB(0xFF,0x14,0x93), "deep pink" },
		{ RGB(0x00,0xBF,0xFF), "deep sky blue" },
		{ RGB(0xFF,0x14,0x93), "DeepPink" },
		{ RGB(0xFF,0x14,0x93), "DeepPink1" },
		{ RGB(0xEE,0x12,0x89), "DeepPink2" },
		{ RGB(0xCD,0x10,0x76), "DeepPink3" },
		{ RGB(0x8B,0x0A,0x50), "DeepPink4" },
		{ RGB(0x00,0xBF,0xFF), "DeepSkyBlue" },
		{ RGB(0x00,0xBF,0xFF), "DeepSkyBlue1" },
		{ RGB(0x00,0xB2,0xEE), "DeepSkyBlue2" },
		{ RGB(0x00,0x9A,0xCD), "DeepSkyBlue3" },
		{ RGB(0x00,0x68,0x8B), "DeepSkyBlue4" },
		{ RGB(0x69,0x69,0x69), "dim gray" },
		{ RGB(0x69,0x69,0x69), "dim grey" },
		{ RGB(0x69,0x69,0x69), "DimGray" },
		{ RGB(0x69,0x69,0x69), "DimGrey" },
		{ RGB(0x1E,0x90,0xFF), "dodger blue" },
		{ RGB(0x1E,0x90,0xFF), "DodgerBlue" },
		{ RGB(0x1E,0x90,0xFF), "DodgerBlue1" },
		{ RGB(0x1C,0x86,0xEE), "DodgerBlue2" },
		{ RGB(0x18,0x74,0xCD), "DodgerBlue3" },
		{ RGB(0x10,0x4E,0x8B), "DodgerBlue4" },
		{ RGB(0xB2,0x22,0x22), "firebrick" },
		{ RGB(0xFF,0x30,0x30), "firebrick1" },
		{ RGB(0xEE,0x2C,0x2C), "firebrick2" },
		{ RGB(0xCD,0x26,0x26), "firebrick3" },
		{ RGB(0x8B,0x1A,0x1A), "firebrick4" },
		{ RGB(0xFF,0xFA,0xF0), "floral white" },
		{ RGB(0xFF,0xFA,0xF0), "FloralWhite" },
		{ RGB(0x22,0x8B,0x22), "forest green" },
		{ RGB(0x22,0x8B,0x22), "ForestGreen" },
		{ RGB(0xDC,0xDC,0xDC), "gainsboro" },
		{ RGB(0xF8,0xF8,0xFF), "ghost white" },
		{ RGB(0xF8,0xF8,0xFF), "GhostWhite" },
		{ RGB(0xFF,0xD7,0x00), "gold" },
		{ RGB(0xFF,0xD7,0x00), "gold1" },
		{ RGB(0xEE,0xC9,0x00), "gold2" },
		{ RGB(0xCD,0xAD,0x00), "gold3" },
		{ RGB(0x8B,0x75,0x00), "gold4" },
		{ RGB(0xDA,0xA5,0x20), "goldenrod" },
		{ RGB(0xFF,0xC1,0x25), "goldenrod1" },
		{ RGB(0xEE,0xB4,0x22), "goldenrod2" },
		{ RGB(0xCD,0x9B,0x1D), "goldenrod3" },
		{ RGB(0x8B,0x69,0x14), "goldenrod4" },
		{ RGB(0xBE,0xBE,0xBE), "gray" },
		{ RGB(0x00,0x00,0x01), "gray0" },
		{ RGB(0x03,0x03,0x03), "gray1" },
		{ RGB(0x1A,0x1A,0x1A), "gray10" },
		{ RGB(0xFF,0xFF,0xFF), "gray100" },
		{ RGB(0x1C,0x1C,0x1C), "gray11" },
		{ RGB(0x1F,0x1F,0x1F), "gray12" },
		{ RGB(0x21,0x21,0x21), "gray13" },
		{ RGB(0x24,0x24,0x24), "gray14" },
		{ RGB(0x26,0x26,0x26), "gray15" },
		{ RGB(0x29,0x29,0x29), "gray16" },
		{ RGB(0x2B,0x2B,0x2B), "gray17" },
		{ RGB(0x2E,0x2E,0x2E), "gray18" },
		{ RGB(0x30,0x30,0x30), "gray19" },
		{ RGB(0x05,0x05,0x05), "gray2" },
		{ RGB(0x33,0x33,0x33), "gray20" },
		{ RGB(0x36,0x36,0x36), "gray21" },
		{ RGB(0x38,0x38,0x38), "gray22" },
		{ RGB(0x3B,0x3B,0x3B), "gray23" },
		{ RGB(0x3D,0x3D,0x3D), "gray24" },
		{ RGB(0x40,0x40,0x40), "gray25" },
		{ RGB(0x42,0x42,0x42), "gray26" },
		{ RGB(0x45,0x45,0x45), "gray27" },
		{ RGB(0x47,0x47,0x47), "gray28" },
		{ RGB(0x4A,0x4A,0x4A), "gray29" },
		{ RGB(0x08,0x08,0x08), "gray3" },
		{ RGB(0x4D,0x4D,0x4D), "gray30" },
		{ RGB(0x4F,0x4F,0x4F), "gray31" },
		{ RGB(0x52,0x52,0x52), "gray32" },
		{ RGB(0x54,0x54,0x54), "gray33" },
		{ RGB(0x57,0x57,0x57), "gray34" },
		{ RGB(0x59,0x59,0x59), "gray35" },
		{ RGB(0x5C,0x5C,0x5C), "gray36" },
		{ RGB(0x5E,0x5E,0x5E), "gray37" },
		{ RGB(0x61,0x61,0x61), "gray38" },
		{ RGB(0x63,0x63,0x63), "gray39" },
		{ RGB(0x0A,0x0A,0x0A), "gray4" },
		{ RGB(0x66,0x66,0x66), "gray40" },
		{ RGB(0x69,0x69,0x69), "gray41" },
		{ RGB(0x6B,0x6B,0x6B), "gray42" },
		{ RGB(0x6E,0x6E,0x6E), "gray43" },
		{ RGB(0x70,0x70,0x70), "gray44" },
		{ RGB(0x73,0x73,0x73), "gray45" },
		{ RGB(0x75,0x75,0x75), "gray46" },
		{ RGB(0x78,0x78,0x78), "gray47" },
		{ RGB(0x7A,0x7A,0x7A), "gray48" },
		{ RGB(0x7D,0x7D,0x7D), "gray49" },
		{ RGB(0x0D,0x0D,0x0D), "gray5" },
		{ RGB(0x7F,0x7F,0x7F), "gray50" },
		{ RGB(0x82,0x82,0x82), "gray51" },
		{ RGB(0x85,0x85,0x85), "gray52" },
		{ RGB(0x87,0x87,0x87), "gray53" },
		{ RGB(0x8A,0x8A,0x8A), "gray54" },
		{ RGB(0x8C,0x8C,0x8C), "gray55" },
		{ RGB(0x8F,0x8F,0x8F), "gray56" },
		{ RGB(0x91,0x91,0x91), "gray57" },
		{ RGB(0x94,0x94,0x94), "gray58" },
		{ RGB(0x96,0x96,0x96), "gray59" },
		{ RGB(0x0F,0x0F,0x0F), "gray6" },
		{ RGB(0x99,0x99,0x99), "gray60" },
		{ RGB(0x9C,0x9C,0x9C), "gray61" },
		{ RGB(0x9E,0x9E,0x9E), "gray62" },
		{ RGB(0xA1,0xA1,0xA1), "gray63" },
		{ RGB(0xA3,0xA3,0xA3), "gray64" },
		{ RGB(0xA6,0xA6,0xA6), "gray65" },
		{ RGB(0xA8,0xA8,0xA8), "gray66" },
		{ RGB(0xAB,0xAB,0xAB), "gray67" },
		{ RGB(0xAD,0xAD,0xAD), "gray68" },
		{ RGB(0xB0,0xB0,0xB0), "gray69" },
		{ RGB(0x12,0x12,0x12), "gray7" },
		{ RGB(0xB3,0xB3,0xB3), "gray70" },
		{ RGB(0xB5,0xB5,0xB5), "gray71" },
		{ RGB(0xB8,0xB8,0xB8), "gray72" },
		{ RGB(0xBA,0xBA,0xBA), "gray73" },
		{ RGB(0xBD,0xBD,0xBD), "gray74" },
		{ RGB(0xBF,0xBF,0xBF), "gray75" },
		{ RGB(0xC2,0xC2,0xC2), "gray76" },
		{ RGB(0xC4,0xC4,0xC4), "gray77" },
		{ RGB(0xC7,0xC7,0xC7), "gray78" },
		{ RGB(0xC9,0xC9,0xC9), "gray79" },
		{ RGB(0x14,0x14,0x14), "gray8" },
		{ RGB(0xCC,0xCC,0xCC), "gray80" },
		{ RGB(0xCF,0xCF,0xCF), "gray81" },
		{ RGB(0xD1,0xD1,0xD1), "gray82" },
		{ RGB(0xD4,0xD4,0xD4), "gray83" },
		{ RGB(0xD6,0xD6,0xD6), "gray84" },
		{ RGB(0xD9,0xD9,0xD9), "gray85" },
		{ RGB(0xDB,0xDB,0xDB), "gray86" },
		{ RGB(0xDE,0xDE,0xDE), "gray87" },
		{ RGB(0xE0,0xE0,0xE0), "gray88" },
		{ RGB(0xE3,0xE3,0xE3), "gray89" },
		{ RGB(0x17,0x17,0x17), "gray9" },
		{ RGB(0xE5,0xE5,0xE5), "gray90" },
		{ RGB(0xE8,0xE8,0xE8), "gray91" },
		{ RGB(0xEB,0xEB,0xEB), "gray92" },
		{ RGB(0xED,0xED,0xED), "gray93" },
		{ RGB(0xF0,0xF0,0xF0), "gray94" },
		{ RGB(0xF2,0xF2,0xF2), "gray95" },
		{ RGB(0xF5,0xF5,0xF5), "gray96" },
		{ RGB(0xF7,0xF7,0xF7), "gray97" },
		{ RGB(0xFA,0xFA,0xFA), "gray98" },
		{ RGB(0xFC,0xFC,0xFC), "gray99" },
		{ RGB(0x00,0xFF,0x00), "green" },
		{ RGB(0xAD,0xFF,0x2F), "green yellow" },
		{ RGB(0x00,0xFF,0x00), "green1" },
		{ RGB(0x00,0xEE,0x00), "green2" },
		{ RGB(0x00,0xCD,0x00), "green3" },
		{ RGB(0x00,0x8B,0x00), "green4" },
		{ RGB(0xAD,0xFF,0x2F), "GreenYellow" },
		{ RGB(0xBE,0xBE,0xBE), "grey" },
		{ RGB(0x00,0x00,0x01), "grey0" },
		{ RGB(0x03,0x03,0x03), "grey1" },
		{ RGB(0x1A,0x1A,0x1A), "grey10" },
		{ RGB(0xFF,0xFF,0xFF), "grey100" },
		{ RGB(0x1C,0x1C,0x1C), "grey11" },
		{ RGB(0x1F,0x1F,0x1F), "grey12" },
		{ RGB(0x21,0x21,0x21), "grey13" },
		{ RGB(0x24,0x24,0x24), "grey14" },
		{ RGB(0x26,0x26,0x26), "grey15" },
		{ RGB(0x29,0x29,0x29), "grey16" },
		{ RGB(0x2B,0x2B,0x2B), "grey17" },
		{ RGB(0x2E,0x2E,0x2E), "grey18" },
		{ RGB(0x30,0x30,0x30), "grey19" },
		{ RGB(0x05,0x05,0x05), "grey2" },
		{ RGB(0x33,0x33,0x33), "grey20" },
		{ RGB(0x36,0x36,0x36), "grey21" },
		{ RGB(0x38,0x38,0x38), "grey22" },
		{ RGB(0x3B,0x3B,0x3B), "grey23" },
		{ RGB(0x3D,0x3D,0x3D), "grey24" },
		{ RGB(0x40,0x40,0x40), "grey25" },
		{ RGB(0x42,0x42,0x42), "grey26" },
		{ RGB(0x45,0x45,0x45), "grey27" },
		{ RGB(0x47,0x47,0x47), "grey28" },
		{ RGB(0x4A,0x4A,0x4A), "grey29" },
		{ RGB(0x08,0x08,0x08), "grey3" },
		{ RGB(0x4D,0x4D,0x4D), "grey30" },
		{ RGB(0x4F,0x4F,0x4F), "grey31" },
		{ RGB(0x52,0x52,0x52), "grey32" },
		{ RGB(0x54,0x54,0x54), "grey33" },
		{ RGB(0x57,0x57,0x57), "grey34" },
		{ RGB(0x59,0x59,0x59), "grey35" },
		{ RGB(0x5C,0x5C,0x5C), "grey36" },
		{ RGB(0x5E,0x5E,0x5E), "grey37" },
		{ RGB(0x61,0x61,0x61), "grey38" },
		{ RGB(0x63,0x63,0x63), "grey39" },
		{ RGB(0x0A,0x0A,0x0A), "grey4" },
		{ RGB(0x66,0x66,0x66), "grey40" },
		{ RGB(0x69,0x69,0x69), "grey41" },
		{ RGB(0x6B,0x6B,0x6B), "grey42" },
		{ RGB(0x6E,0x6E,0x6E), "grey43" },
		{ RGB(0x70,0x70,0x70), "grey44" },
		{ RGB(0x73,0x73,0x73), "grey45" },
		{ RGB(0x75,0x75,0x75), "grey46" },
		{ RGB(0x78,0x78,0x78), "grey47" },
		{ RGB(0x7A,0x7A,0x7A), "grey48" },
		{ RGB(0x7D,0x7D,0x7D), "grey49" },
		{ RGB(0x0D,0x0D,0x0D), "grey5" },
		{ RGB(0x7F,0x7F,0x7F), "grey50" },
		{ RGB(0x82,0x82,0x82), "grey51" },
		{ RGB(0x85,0x85,0x85), "grey52" },
		{ RGB(0x87,0x87,0x87), "grey53" },
		{ RGB(0x8A,0x8A,0x8A), "grey54" },
		{ RGB(0x8C,0x8C,0x8C), "grey55" },
		{ RGB(0x8F,0x8F,0x8F), "grey56" },
		{ RGB(0x91,0x91,0x91), "grey57" },
		{ RGB(0x94,0x94,0x94), "grey58" },
		{ RGB(0x96,0x96,0x96), "grey59" },
		{ RGB(0x0F,0x0F,0x0F), "grey6" },
		{ RGB(0x99,0x99,0x99), "grey60" },
		{ RGB(0x9C,0x9C,0x9C), "grey61" },
		{ RGB(0x9E,0x9E,0x9E), "grey62" },
		{ RGB(0xA1,0xA1,0xA1), "grey63" },
		{ RGB(0xA3,0xA3,0xA3), "grey64" },
		{ RGB(0xA6,0xA6,0xA6), "grey65" },
		{ RGB(0xA8,0xA8,0xA8), "grey66" },
		{ RGB(0xAB,0xAB,0xAB), "grey67" },
		{ RGB(0xAD,0xAD,0xAD), "grey68" },
		{ RGB(0xB0,0xB0,0xB0), "grey69" },
		{ RGB(0x12,0x12,0x12), "grey7" },
		{ RGB(0xB3,0xB3,0xB3), "grey70" },
		{ RGB(0xB5,0xB5,0xB5), "grey71" },
		{ RGB(0xB8,0xB8,0xB8), "grey72" },
		{ RGB(0xBA,0xBA,0xBA), "grey73" },
		{ RGB(0xBD,0xBD,0xBD), "grey74" },
		{ RGB(0xBF,0xBF,0xBF), "grey75" },
		{ RGB(0xC2,0xC2,0xC2), "grey76" },
		{ RGB(0xC4,0xC4,0xC4), "grey77" },
		{ RGB(0xC7,0xC7,0xC7), "grey78" },
		{ RGB(0xC9,0xC9,0xC9), "grey79" },
		{ RGB(0x14,0x14,0x14), "grey8" },
		{ RGB(0xCC,0xCC,0xCC), "grey80" },
		{ RGB(0xCF,0xCF,0xCF), "grey81" },
		{ RGB(0xD1,0xD1,0xD1), "grey82" },
		{ RGB(0xD4,0xD4,0xD4), "grey83" },
		{ RGB(0xD6,0xD6,0xD6), "grey84" },
		{ RGB(0xD9,0xD9,0xD9), "grey85" },
		{ RGB(0xDB,0xDB,0xDB), "grey86" },
		{ RGB(0xDE,0xDE,0xDE), "grey87" },
		{ RGB(0xE0,0xE0,0xE0), "grey88" },
		{ RGB(0xE3,0xE3,0xE3), "grey89" },
		{ RGB(0x17,0x17,0x17), "grey9" },
		{ RGB(0xE5,0xE5,0xE5), "grey90" },
		{ RGB(0xE8,0xE8,0xE8), "grey91" },
		{ RGB(0xEB,0xEB,0xEB), "grey92" },
		{ RGB(0xED,0xED,0xED), "grey93" },
		{ RGB(0xF0,0xF0,0xF0), "grey94" },
		{ RGB(0xF2,0xF2,0xF2), "grey95" },
		{ RGB(0xF5,0xF5,0xF5), "grey96" },
		{ RGB(0xF7,0xF7,0xF7), "grey97" },
		{ RGB(0xFA,0xFA,0xFA), "grey98" },
		{ RGB(0xFC,0xFC,0xFC), "grey99" },
		{ RGB(0xF0,0xFF,0xF0), "honeydew" },
		{ RGB(0xF0,0xFF,0xF0), "honeydew1" },
		{ RGB(0xE0,0xEE,0xE0), "honeydew2" },
		{ RGB(0xC1,0xCD,0xC1), "honeydew3" },
		{ RGB(0x83,0x8B,0x83), "honeydew4" },
		{ RGB(0xFF,0x69,0xB4), "hot pink" },
		{ RGB(0xFF,0x69,0xB4), "HotPink" },
		{ RGB(0xFF,0x6E,0xB4), "HotPink1" },
		{ RGB(0xEE,0x6A,0xA7), "HotPink2" },
		{ RGB(0xCD,0x60,0x90), "HotPink3" },
		{ RGB(0x8B,0x3A,0x62), "HotPink4" },
		{ RGB(0xCD,0x5C,0x5C), "indian red" },
		{ RGB(0xCD,0x5C,0x5C), "IndianRed" },
		{ RGB(0xFF,0x6A,0x6A), "IndianRed1" },
		{ RGB(0xEE,0x63,0x63), "IndianRed2" },
		{ RGB(0xCD,0x55,0x55), "IndianRed3" },
		{ RGB(0x8B,0x3A,0x3A), "IndianRed4" },
		{ RGB(0xFF,0xFF,0xF0), "ivory" },
		{ RGB(0xFF,0xFF,0xF0), "ivory1" },
		{ RGB(0xEE,0xEE,0xE0), "ivory2" },
		{ RGB(0xCD,0xCD,0xC1), "ivory3" },
		{ RGB(0x8B,0x8B,0x83), "ivory4" },
		{ RGB(0xF0,0xE6,0x8C), "khaki" },
		{ RGB(0xFF,0xF6,0x8F), "khaki1" },
		{ RGB(0xEE,0xE6,0x85), "khaki2" },
		{ RGB(0xCD,0xC6,0x73), "khaki3" },
		{ RGB(0x8B,0x86,0x4E), "khaki4" },
		{ RGB(0xE6,0xE6,0xFA), "lavender" },
		{ RGB(0xFF,0xF0,0xF5), "lavender blush" },
		{ RGB(0xFF,0xF0,0xF5), "LavenderBlush" },
		{ RGB(0xFF,0xF0,0xF5), "LavenderBlush1" },
		{ RGB(0xEE,0xE0,0xE5), "LavenderBlush2" },
		{ RGB(0xCD,0xC1,0xC5), "LavenderBlush3" },
		{ RGB(0x8B,0x83,0x86), "LavenderBlush4" },
		{ RGB(0x7C,0xFC,0x00), "lawn green" },
		{ RGB(0x7C,0xFC,0x00), "LawnGreen" },
		{ RGB(0xFF,0xFA,0xCD), "lemon chiffon" },
		{ RGB(0xFF,0xFA,0xCD), "LemonChiffon" },
		{ RGB(0xFF,0xFA,0xCD), "LemonChiffon1" },
		{ RGB(0xEE,0xE9,0xBF), "LemonChiffon2" },
		{ RGB(0xCD,0xC9,0xA5), "LemonChiffon3" },
		{ RGB(0x8B,0x89,0x70), "LemonChiffon4" },
		{ RGB(0xAD,0xD8,0xE6), "light blue" },
		{ RGB(0xF0,0x80,0x80), "light coral" },
		{ RGB(0xE0,0xFF,0xFF), "light cyan" },
		{ RGB(0xEE,0xDD,0x82), "light goldenrod" },
		{ RGB(0xFA,0xFA,0xD2), "light goldenrod yellow" },
		{ RGB(0xD3,0xD3,0xD3), "light gray" },
		{ RGB(0xD3,0xD3,0xD3), "light grey" },
		{ RGB(0xFF,0xB6,0xC1), "light pink" },
		{ RGB(0xFF,0xA0,0x7A), "light salmon" },
		{ RGB(0x20,0xB2,0xAA), "light sea green" },
		{ RGB(0x87,0xCE,0xFA), "light sky blue" },
		{ RGB(0x84,0x70,0xFF), "light slate blue" },
		{ RGB(0x77,0x88,0x99), "light slate gray" },
		{ RGB(0x77,0x88,0x99), "light slate grey" },
		{ RGB(0xB0,0xC4,0xDE), "light steel blue" },
		{ RGB(0xFF,0xFF,0xE0), "light yellow" },
		{ RGB(0xAD,0xD8,0xE6), "LightBlue" },
		{ RGB(0xBF,0xEF,0xFF), "LightBlue1" },
		{ RGB(0xB2,0xDF,0xEE), "LightBlue2" },
		{ RGB(0x9A,0xC0,0xCD), "LightBlue3" },
		{ RGB(0x68,0x83,0x8B), "LightBlue4" },
		{ RGB(0xF0,0x80,0x80), "LightCoral" },
		{ RGB(0xE0,0xFF,0xFF), "LightCyan" },
		{ RGB(0xE0,0xFF,0xFF), "LightCyan1" },
		{ RGB(0xD1,0xEE,0xEE), "LightCyan2" },
		{ RGB(0xB4,0xCD,0xCD), "LightCyan3" },
		{ RGB(0x7A,0x8B,0x8B), "LightCyan4" },
		{ RGB(0xEE,0xDD,0x82), "LightGoldenrod" },
		{ RGB(0xFF,0xEC,0x8B), "LightGoldenrod1" },
		{ RGB(0xEE,0xDC,0x82), "LightGoldenrod2" },
		{ RGB(0xCD,0xBE,0x70), "LightGoldenrod3" },
		{ RGB(0x8B,0x81,0x4C), "LightGoldenrod4" },
		{ RGB(0xFA,0xFA,0xD2), "LightGoldenrodYellow" },
		{ RGB(0xD3,0xD3,0xD3), "LightGray" },
		{ RGB(0xD3,0xD3,0xD3), "LightGrey" },
		{ RGB(0xFF,0xB6,0xC1), "LightPink" },
		{ RGB(0xFF,0xAE,0xB9), "LightPink1" },
		{ RGB(0xEE,0xA2,0xAD), "LightPink2" },
		{ RGB(0xCD,0x8C,0x95), "LightPink3" },
		{ RGB(0x8B,0x5F,0x65), "LightPink4" },
		{ RGB(0xFF,0xA0,0x7A), "LightSalmon" },
		{ RGB(0xFF,0xA0,0x7A), "LightSalmon1" },
		{ RGB(0xEE,0x95,0x72), "LightSalmon2" },
		{ RGB(0xCD,0x81,0x62), "LightSalmon3" },
		{ RGB(0x8B,0x57,0x42), "LightSalmon4" },
		{ RGB(0x20,0xB2,0xAA), "LightSeaGreen" },
		{ RGB(0x87,0xCE,0xFA), "LightSkyBlue" },
		{ RGB(0xB0,0xE2,0xFF), "LightSkyBlue1" },
		{ RGB(0xA4,0xD3,0xEE), "LightSkyBlue2" },
		{ RGB(0x8D,0xB6,0xCD), "LightSkyBlue3" },
		{ RGB(0x60,0x7B,0x8B), "LightSkyBlue4" },
		{ RGB(0x84,0x70,0xFF), "LightSlateBlue" },
		{ RGB(0x77,0x88,0x99), "LightSlateGray" },
		{ RGB(0x77,0x88,0x99), "LightSlateGrey" },
		{ RGB(0xB0,0xC4,0xDE), "LightSteelBlue" },
		{ RGB(0xCA,0xE1,0xFF), "LightSteelBlue1" },
		{ RGB(0xBC,0xD2,0xEE), "LightSteelBlue2" },
		{ RGB(0xA2,0xB5,0xCD), "LightSteelBlue3" },
		{ RGB(0x6E,0x7B,0x8B), "LightSteelBlue4" },
		{ RGB(0xFF,0xFF,0xE0), "LightYellow" },
		{ RGB(0xFF,0xFF,0xE0), "LightYellow1" },
		{ RGB(0xEE,0xEE,0xD1), "LightYellow2" },
		{ RGB(0xCD,0xCD,0xB4), "LightYellow3" },
		{ RGB(0x8B,0x8B,0x7A), "LightYellow4" },
		{ RGB(0x32,0xCD,0x32), "lime green" },
		{ RGB(0x32,0xCD,0x32), "LimeGreen" },
		{ RGB(0xFA,0xF0,0xE6), "linen" },
		{ RGB(0xFF,0x00,0xFF), "magenta" },
		{ RGB(0xFF,0x00,0xFF), "magenta1" },
		{ RGB(0xEE,0x00,0xEE), "magenta2" },
		{ RGB(0xCD,0x00,0xCD), "magenta3" },
		{ RGB(0x8B,0x00,0x8B), "magenta4" },
		{ RGB(0xB0,0x30,0x60), "maroon" },
		{ RGB(0xFF,0x34,0xB3), "maroon1" },
		{ RGB(0xEE,0x30,0xA7), "maroon2" },
		{ RGB(0xCD,0x29,0x90), "maroon3" },
		{ RGB(0x8B,0x1C,0x62), "maroon4" },
		{ RGB(0x66,0xCD,0xAA), "medium aquamarine" },
		{ RGB(0x00,0x00,0xCD), "medium blue" },
		{ RGB(0xBA,0x55,0xD3), "medium orchid" },
		{ RGB(0x93,0x70,0xDB), "medium purple" },
		{ RGB(0x3C,0xB3,0x71), "medium sea green" },
		{ RGB(0x7B,0x68,0xEE), "medium slate blue" },
		{ RGB(0x00,0xFA,0x9A), "medium spring green" },
		{ RGB(0x48,0xD1,0xCC), "medium turquoise" },
		{ RGB(0xC7,0x15,0x85), "medium violet red" },
		{ RGB(0x66,0xCD,0xAA), "MediumAquamarine" },
		{ RGB(0x00,0x00,0xCD), "MediumBlue" },
		{ RGB(0xBA,0x55,0xD3), "MediumOrchid" },
		{ RGB(0xE0,0x66,0xFF), "MediumOrchid1" },
		{ RGB(0xD1,0x5F,0xEE), "MediumOrchid2" },
		{ RGB(0xB4,0x52,0xCD), "MediumOrchid3" },
		{ RGB(0x7A,0x37,0x8B), "MediumOrchid4" },
		{ RGB(0x93,0x70,0xDB), "MediumPurple" },
		{ RGB(0xAB,0x82,0xFF), "MediumPurple1" },
		{ RGB(0x9F,0x79,0xEE), "MediumPurple2" },
		{ RGB(0x89,0x68,0xCD), "MediumPurple3" },
		{ RGB(0x5D,0x47,0x8B), "MediumPurple4" },
		{ RGB(0x3C,0xB3,0x71), "MediumSeaGreen" },
		{ RGB(0x7B,0x68,0xEE), "MediumSlateBlue" },
		{ RGB(0x00,0xFA,0x9A), "MediumSpringGreen" },
		{ RGB(0x48,0xD1,0xCC), "MediumTurquoise" },
		{ RGB(0xC7,0x15,0x85), "MediumVioletRed" },
		{ RGB(0x19,0x19,0x70), "midnight blue" },
		{ RGB(0x19,0x19,0x70), "MidnightBlue" },
		{ RGB(0xF5,0xFF,0xFA), "mint cream" },
		{ RGB(0xF5,0xFF,0xFA), "MintCream" },
		{ RGB(0xFF,0xE4,0xE1), "misty rose" },
		{ RGB(0xFF,0xE4,0xE1), "MistyRose" },
		{ RGB(0xFF,0xE4,0xE1), "MistyRose1" },
		{ RGB(0xEE,0xD5,0xD2), "MistyRose2" },
		{ RGB(0xCD,0xB7,0xB5), "MistyRose3" },
		{ RGB(0x8B,0x7D,0x7B), "MistyRose4" },
		{ RGB(0xFF,0xE4,0xB5), "moccasin" },
		{ RGB(0xFF,0xDE,0xAD), "navajo white" },
		{ RGB(0xFF,0xDE,0xAD), "NavajoWhite" },
		{ RGB(0xFF,0xDE,0xAD), "NavajoWhite1" },
		{ RGB(0xEE,0xCF,0xA1), "NavajoWhite2" },
		{ RGB(0xCD,0xB3,0x8B), "NavajoWhite3" },
		{ RGB(0x8B,0x79,0x5E), "NavajoWhite4" },
		{ RGB(0x00,0x00,0x80), "navy" },
		{ RGB(0x00,0x00,0x80), "navy blue" },
		{ RGB(0x00,0x00,0x80), "NavyBlue" },
		{ RGB(0xFD,0xF5,0xE6), "old lace" },
		{ RGB(0xFD,0xF5,0xE6), "OldLace" },
		{ RGB(0x6B,0x8E,0x23), "olive drab" },
		{ RGB(0x6B,0x8E,0x23), "OliveDrab" },
		{ RGB(0xC0,0xFF,0x3E), "OliveDrab1" },
		{ RGB(0xB3,0xEE,0x3A), "OliveDrab2" },
		{ RGB(0x9A,0xCD,0x32), "OliveDrab3" },
		{ RGB(0x69,0x8B,0x22), "OliveDrab4" },
		{ RGB(0xFF,0xA5,0x00), "orange" },
		{ RGB(0xFF,0x45,0x00), "orange red" },
		{ RGB(0xFF,0xA5,0x00), "orange1" },
		{ RGB(0xEE,0x9A,0x00), "orange2" },
		{ RGB(0xCD,0x85,0x00), "orange3" },
		{ RGB(0x8B,0x5A,0x00), "orange4" },
		{ RGB(0xFF,0x45,0x00), "OrangeRed" },
		{ RGB(0xFF,0x45,0x00), "OrangeRed1" },
		{ RGB(0xEE,0x40,0x00), "OrangeRed2" },
		{ RGB(0xCD,0x37,0x00), "OrangeRed3" },
		{ RGB(0x8B,0x25,0x00), "OrangeRed4" },
		{ RGB(0xDA,0x70,0xD6), "orchid" },
		{ RGB(0xFF,0x83,0xFA), "orchid1" },
		{ RGB(0xEE,0x7A,0xE9), "orchid2" },
		{ RGB(0xCD,0x69,0xC9), "orchid3" },
		{ RGB(0x8B,0x47,0x89), "orchid4" },
		{ RGB(0xEE,0xE8,0xAA), "pale goldenrod" },
		{ RGB(0x98,0xFB,0x98), "pale green" },
		{ RGB(0xAF,0xEE,0xEE), "pale turquoise" },
		{ RGB(0xDB,0x70,0x93), "pale violet red" },
		{ RGB(0xEE,0xE8,0xAA), "PaleGoldenrod" },
		{ RGB(0x98,0xFB,0x98), "PaleGreen" },
		{ RGB(0x9A,0xFF,0x9A), "PaleGreen1" },
		{ RGB(0x90,0xEE,0x90), "PaleGreen2" },
		{ RGB(0x7C,0xCD,0x7C), "PaleGreen3" },
		{ RGB(0x54,0x8B,0x54), "PaleGreen4" },
		{ RGB(0xAF,0xEE,0xEE), "PaleTurquoise" },
		{ RGB(0xBB,0xFF,0xFF), "PaleTurquoise1" },
		{ RGB(0xAE,0xEE,0xEE), "PaleTurquoise2" },
		{ RGB(0x96,0xCD,0xCD), "PaleTurquoise3" },
		{ RGB(0x66,0x8B,0x8B), "PaleTurquoise4" },
		{ RGB(0xDB,0x70,0x93), "PaleVioletRed" },
		{ RGB(0xFF,0x82,0xAB), "PaleVioletRed1" },
		{ RGB(0xEE,0x79,0x9F), "PaleVioletRed2" },
		{ RGB(0xCD,0x68,0x89), "PaleVioletRed3" },
		{ RGB(0x8B,0x47,0x5D), "PaleVioletRed4" },
		{ RGB(0xFF,0xEF,0xD5), "papaya whip" },
		{ RGB(0xFF,0xEF,0xD5), "PapayaWhip" },
		{ RGB(0xFF,0xDA,0xB9), "peach puff" },
		{ RGB(0xFF,0xDA,0xB9), "PeachPuff" },
		{ RGB(0xFF,0xDA,0xB9), "PeachPuff1" },
		{ RGB(0xEE,0xCB,0xAD), "PeachPuff2" },
		{ RGB(0xCD,0xAF,0x95), "PeachPuff3" },
		{ RGB(0x8B,0x77,0x65), "PeachPuff4" },
		{ RGB(0xCD,0x85,0x3F), "peru" },
		{ RGB(0xFF,0xC0,0xCB), "pink" },
		{ RGB(0xFF,0xB5,0xC5), "pink1" },
		{ RGB(0xEE,0xA9,0xB8), "pink2" },
		{ RGB(0xCD,0x91,0x9E), "pink3" },
		{ RGB(0x8B,0x63,0x6C), "pink4" },
		{ RGB(0xDD,0xA0,0xDD), "plum" },
		{ RGB(0xFF,0xBB,0xFF), "plum1" },
		{ RGB(0xEE,0xAE,0xEE), "plum2" },
		{ RGB(0xCD,0x96,0xCD), "plum3" },
		{ RGB(0x8B,0x66,0x8B), "plum4" },
		{ RGB(0xB0,0xE0,0xE6), "powder blue" },
		{ RGB(0xB0,0xE0,0xE6), "PowderBlue" },
		{ RGB(0xA0,0x20,0xF0), "purple" },
		{ RGB(0x9B,0x30,0xFF), "purple1" },
		{ RGB(0x91,0x2C,0xEE), "purple2" },
		{ RGB(0x7D,0x26,0xCD), "purple3" },
		{ RGB(0x55,0x1A,0x8B), "purple4" },
		{ RGB(0xFF,0x00,0x00), "red" },
		{ RGB(0xFF,0x00,0x00), "red1" },
		{ RGB(0xEE,0x00,0x00), "red2" },
		{ RGB(0xCD,0x00,0x00), "red3" },
		{ RGB(0x8B,0x00,0x00), "red4" },
		{ RGB(0xBC,0x8F,0x8F), "rosy brown" },
		{ RGB(0xBC,0x8F,0x8F), "RosyBrown" },
		{ RGB(0xFF,0xC1,0xC1), "RosyBrown1" },
		{ RGB(0xEE,0xB4,0xB4), "RosyBrown2" },
		{ RGB(0xCD,0x9B,0x9B), "RosyBrown3" },
		{ RGB(0x8B,0x69,0x69), "RosyBrown4" },
		{ RGB(0x41,0x69,0xE1), "royal blue" },
		{ RGB(0x41,0x69,0xE1), "RoyalBlue" },
		{ RGB(0x48,0x76,0xFF), "RoyalBlue1" },
		{ RGB(0x43,0x6E,0xEE), "RoyalBlue2" },
		{ RGB(0x3A,0x5F,0xCD), "RoyalBlue3" },
		{ RGB(0x27,0x40,0x8B), "RoyalBlue4" },
		{ RGB(0x8B,0x45,0x13), "saddle brown" },
		{ RGB(0x8B,0x45,0x13), "SaddleBrown" },
		{ RGB(0xFA,0x80,0x72), "salmon" },
		{ RGB(0xFF,0x8C,0x69), "salmon1" },
		{ RGB(0xEE,0x82,0x62), "salmon2" },
		{ RGB(0xCD,0x70,0x54), "salmon3" },
		{ RGB(0x8B,0x4C,0x39), "salmon4" },
		{ RGB(0xF4,0xA4,0x60), "sandy brown" },
		{ RGB(0xF4,0xA4,0x60), "SandyBrown" },
		{ RGB(0x2E,0x8B,0x57), "sea green" },
		{ RGB(0x2E,0x8B,0x57), "SeaGreen" },
		{ RGB(0x54,0xFF,0x9F), "SeaGreen1" },
		{ RGB(0x4E,0xEE,0x94), "SeaGreen2" },
		{ RGB(0x43,0xCD,0x80), "SeaGreen3" },
		{ RGB(0x2E,0x8B,0x57), "SeaGreen4" },
		{ RGB(0xFF,0xF5,0xEE), "seashell" },
		{ RGB(0xFF,0xF5,0xEE), "seashell1" },
		{ RGB(0xEE,0xE5,0xDE), "seashell2" },
		{ RGB(0xCD,0xC5,0xBF), "seashell3" },
		{ RGB(0x8B,0x86,0x82), "seashell4" },
		{ RGB(0xA0,0x52,0x2D), "sienna" },
		{ RGB(0xFF,0x82,0x47), "sienna1" },
		{ RGB(0xEE,0x79,0x42), "sienna2" },
		{ RGB(0xCD,0x68,0x39), "sienna3" },
		{ RGB(0x8B,0x47,0x26), "sienna4" },
		{ RGB(0x87,0xCE,0xEB), "sky blue" },
		{ RGB(0x87,0xCE,0xEB), "SkyBlue" },
		{ RGB(0x87,0xCE,0xFF), "SkyBlue1" },
		{ RGB(0x7E,0xC0,0xEE), "SkyBlue2" },
		{ RGB(0x6C,0xA6,0xCD), "SkyBlue3" },
		{ RGB(0x4A,0x70,0x8B), "SkyBlue4" },
		{ RGB(0x6A,0x5A,0xCD), "slate blue" },
		{ RGB(0x70,0x80,0x90), "slate gray" },
		{ RGB(0x70,0x80,0x90), "slate grey" },
		{ RGB(0x6A,0x5A,0xCD), "SlateBlue" },
		{ RGB(0x83,0x6F,0xFF), "SlateBlue1" },
		{ RGB(0x7A,0x67,0xEE), "SlateBlue2" },
		{ RGB(0x69,0x59,0xCD), "SlateBlue3" },
		{ RGB(0x47,0x3C,0x8B), "SlateBlue4" },
		{ RGB(0x70,0x80,0x90), "SlateGray" },
		{ RGB(0xC6,0xE2,0xFF), "SlateGray1" },
		{ RGB(0xB9,0xD3,0xEE), "SlateGray2" },
		{ RGB(0x9F,0xB6,0xCD), "SlateGray3" },
		{ RGB(0x6C,0x7B,0x8B), "SlateGray4" },
		{ RGB(0x70,0x80,0x90), "SlateGrey" },
		{ RGB(0xFF,0xFA,0xFA), "snow" },
		{ RGB(0xFF,0xFA,0xFA), "snow1" },
		{ RGB(0xEE,0xE9,0xE9), "snow2" },
		{ RGB(0xCD,0xC9,0xC9), "snow3" },
		{ RGB(0x8B,0x89,0x89), "snow4" },
		{ RGB(0x00,0xFF,0x7F), "spring green" },
		{ RGB(0x00,0xFF,0x7F), "SpringGreen" },
		{ RGB(0x00,0xFF,0x7F), "SpringGreen1" },
		{ RGB(0x00,0xEE,0x76), "SpringGreen2" },
		{ RGB(0x00,0xCD,0x66), "SpringGreen3" },
		{ RGB(0x00,0x8B,0x45), "SpringGreen4" },
		{ RGB(0x46,0x82,0xB4), "steel blue" },
		{ RGB(0x46,0x82,0xB4), "SteelBlue" },
		{ RGB(0x63,0xB8,0xFF), "SteelBlue1" },
		{ RGB(0x5C,0xAC,0xEE), "SteelBlue2" },
		{ RGB(0x4F,0x94,0xCD), "SteelBlue3" },
		{ RGB(0x36,0x64,0x8B), "SteelBlue4" },
		{ RGB(0xD2,0xB4,0x8C), "tan" },
		{ RGB(0xFF,0xA5,0x4F), "tan1" },
		{ RGB(0xEE,0x9A,0x49), "tan2" },
		{ RGB(0xCD,0x85,0x3F), "tan3" },
		{ RGB(0x8B,0x5A,0x2B), "tan4" },
		{ RGB(0xD8,0xBF,0xD8), "thistle" },
		{ RGB(0xFF,0xE1,0xFF), "thistle1" },
		{ RGB(0xEE,0xD2,0xEE), "thistle2" },
		{ RGB(0xCD,0xB5,0xCD), "thistle3" },
		{ RGB(0x8B,0x7B,0x8B), "thistle4" },
		{ RGB(0xFF,0x63,0x47), "tomato" },
		{ RGB(0xFF,0x63,0x47), "tomato1" },
		{ RGB(0xEE,0x5C,0x42), "tomato2" },
		{ RGB(0xCD,0x4F,0x39), "tomato3" },
		{ RGB(0x8B,0x36,0x26), "tomato4" },
		{ RGB(0x40,0xE0,0xD0), "turquoise" },
		{ RGB(0x00,0xF5,0xFF), "turquoise1" },
		{ RGB(0x00,0xE5,0xEE), "turquoise2" },
		{ RGB(0x00,0xC5,0xCD), "turquoise3" },
		{ RGB(0x00,0x86,0x8B), "turquoise4" },
		{ RGB(0xEE,0x82,0xEE), "violet" },
		{ RGB(0xD0,0x20,0x90), "violet red" },
		{ RGB(0xD0,0x20,0x90), "VioletRed" },
		{ RGB(0xFF,0x3E,0x96), "VioletRed1" },
		{ RGB(0xEE,0x3A,0x8C), "VioletRed2" },
		{ RGB(0xCD,0x32,0x78), "VioletRed3" },
		{ RGB(0x8B,0x22,0x52), "VioletRed4" },
		{ RGB(0xF5,0xDE,0xB3), "wheat" },
		{ RGB(0xFF,0xE7,0xBA), "wheat1" },
		{ RGB(0xEE,0xD8,0xAE), "wheat2" },
		{ RGB(0xCD,0xBA,0x96), "wheat3" },
		{ RGB(0x8B,0x7E,0x66), "wheat4" },
		{ RGB(0xFF,0xFF,0xFF), "white" },
		{ RGB(0xF5,0xF5,0xF5), "white smoke" },
		{ RGB(0xF5,0xF5,0xF5), "WhiteSmoke" },
		{ RGB(0xFF,0xFF,0x00), "yellow" },
		{ RGB(0x9A,0xCD,0x32), "yellow green" },
		{ RGB(0xFF,0xFF,0x00), "yellow1" },
		{ RGB(0xEE,0xEE,0x00), "yellow2" },
		{ RGB(0xCD,0xCD,0x00), "yellow3" },
		{ RGB(0x8B,0x8B,0x00), "yellow4" },
		{ RGB(0x9A,0xCD,0x32), "YellowGreen" },
	};

	if(*str == '#') {
		char	format[256];
		int	span = (int)(strlen(str)-1) / 3;
		int	r, g, b;
		sprintf_s(format, "%%%dx%%%dx%%%dx", span, span, span);
		if(sscanf_s(str+1, format, &r, &g, &b) == 3) {
			if(span < 2) {
				r <<= 4;
				g <<= 4;
				b <<= 4;
			}
			else if(span > 2) {
				r >>= 4 * (span-2);
				g >>= 4 * (span-2);
				b >>= 4 * (span-2);
			}
			if(r < 1 && g < 1 && b < 1) b++;
			ret = RGB(r,g,b);
			return(true);
		}
	}
	else {
		unsigned int	i;
		for(i = 0 ; i < sizeof(colors) / sizeof(colors[0]) ; i++) {
			if(!strcasecmp(colors[i].name, str)) {
				ret = colors[i].color;
				return(true);
			}
		}
	}

	fprintf(stderr, "ERROR: invalid color. \"%s\"\n", str);
	fflush(stderr);
	return(false);
}

static void extract(char *str, std::string& app, std::string& name, std::string& value)
{
	char	*c1, *c2, *c3, *c4;
	app.erase();
	name.erase();
	value.erase();
	c1 = strchr(str, '*');
	if(!c1) return;
	c2 = strchr(c1, ':');
	if(!c2) return;
	*c1++ = 0;
	*c2++ = 0;
	for(c3 = c2-2 ; c3 > c1 && *c3 <= ' ' ; c3--);
	if(*++c3 <= ' ') *c3 = 0;
	app = str;
	name = c1;
	c4 = c2 + strlen(c2)-1;
	for(        ; c2 < c4 && *c2<=' ' && *c2>0 ; c2++);
	for(c3 = c4 ; c3 > c2 && *c3<=' ' && *c2>0 ; c3--);
	if(*++c3 <= ' ' && *c3 > 0) *c3 = 0;
	value = c2;
}

static bool lookupBoolean(const char *value)
{
	if(!strcasecmp(value, "true") ||
	   !strcasecmp(value, "yes") ||
	   !strcasecmp(value, "on") ||
	   !strcasecmp(value, "1"))
		return(true);
	return(false);
}

static void usage_fmtL(const char *name, const char *type)
{
	if(!name) return;
	size_t	i;
	fprintf(stdout, "  %s:", name);
	i = 3 + strlen(name);
	for( ; i < 23 ; fputc(' ', stdout), i++);
	fprintf(stdout, "%s\n", type ? type : "");
}

static void usage_fmtS(const char *name, const char *type, const char *desc)
{
	if(!name) return;
	size_t	i;
	if(type && !strcmp(type, "boolean")) {
		fprintf(stdout, "  -/+%s", name);
		i = 5 + strlen(name);
	}
	else if(type) {
		fprintf(stdout, "  -%s <%s>", name, type);
		i = 6 + strlen(name) + strlen(type);
	}
	else {
		fprintf(stdout, "  -%s", name);
		i = 3 + strlen(name);
	}
	for( ; i < 22 ; fputc(' ', stdout), i++);
	fprintf(stdout, " : %s\n", desc ? desc : "");
}


/*****************************************************************************/


void	ckOpt::cmdsMake(int argc, char *argv[])
{
	m_cmd.erase();
	char *chk;
	for(int i = 0 ; i < argc ; i++) {
		chk = argv[i];
		while(!strchr(" &()[]{}^=;!'+,`~", *chk)) chk++;
		if(*chk) {
			m_cmd += "\"";
			m_cmd += argv[i];
			m_cmd += "\" ";
		}
		else {
			m_cmd += argv[i];
			m_cmd += " ";
		}
	}
}

void	ckOpt::geometry(const char *str)
{
	const char	*c = str;
	int	w = 0;
	int	h = 0;
	int	x = 0;
	int	y = 0;
	bool	minusX = false;
	bool	minusY = false;

	if(!c || *c == 0)
		return;
	for( ; *c != 0 && '0' <= *c && *c <= '9' ; c++)
		w = w * 10 + (*c - '0');
	if(*c == 'x') {
		for(c++ ; *c != 0 && '0' <= *c && *c <= '9' ; c++)
			h = h * 10 + (*c - '0');
	}
	if(*c != 0) {
		if(*c == '-') { minusX = true; c++; }
		else if(*c == '+') { c++; }
		for( ; *c != 0 && '0' <= *c && *c <= '9' ; c++)
			x = x * 10 + (*c - '0');
		if(minusX) x = -x-1;

		if(*c == '-') { minusY = true; c++; }
		else if(*c == '+') { c++; }
		for( ; *c != 0 && '0' <= *c && *c <= '9' ; c++)
			y = y * 10 + (*c - '0');
		if(minusY) y = -y-1;

		m_isWinPos = true;
		m_winPosX = x;
		m_winPosY = y;
	}
	m_winCharW = (w>0) ? w : 1;
	m_winCharH = (h>0) ? h : 1;
}

/*****************************************************************************/

ckOpt::ckOpt()
{
	m_isWinPos = false;
	m_winPosX = 0;
	m_winPosY = 0;
	m_winCharW = 80;
	m_winCharH = 24;
	m_isIconic = false;
	m_fontSize = 14;
	m_colors[0]  = RGB(0x00, 0x00, 0x01);
	m_colors[1]  = RGB(0x00, 0x00, 0x80);
	m_colors[2]  = RGB(0x00, 0x80, 0x00);
	m_colors[3]  = RGB(0x00, 0x80, 0x80);
	m_colors[4]  = RGB(0x80, 0x00, 0x00);
	m_colors[5]  = RGB(0x80, 0x00, 0x80);
	m_colors[6]  = RGB(0x80, 0x80, 0x00);
	m_colors[7]  = RGB(0xC0, 0xC0, 0xC0);
	m_colors[8]  = RGB(0x80, 0x80, 0x80);
	m_colors[9]  = RGB(0x00, 0x00, 0xFF);
	m_colors[10] = RGB(0x00, 0xFF, 0x00);
	m_colors[11] = RGB(0x00, 0xFF, 0xFF);
	m_colors[12] = RGB(0xFF, 0x00, 0x00);
	m_colors[13] = RGB(0xFF, 0x00, 0xFF);
	m_colors[14] = RGB(0xFF, 0xFF, 0x00);
	m_colors[15] = RGB(0xFF, 0xFF, 0xFF);
	m_colorFg    = RGB(0xC0, 0xC0, 0xC0); // cursor fg
	m_colorBg    = RGB(0x00, 0x00, 0x01); // cursor bg
	m_colorCursor = RGB(0xC0, 0xC0, 0x80);
	m_colorCursorIme = RGB(0xC0, 0x00, 0x00);
	m_scrollHide = false;
	m_scrollRight = true;
	m_saveLines = 500;
	m_borderSize = 1;
	m_lineSpace = 0;
	m_transp = 255;
	m_isTranspColor = false;
	m_transpColor = 0;
	m_isTopMost = false;
	m_config_file[0] = '\0';
}

ckOpt::~ckOpt()
{
}

#define _CHK_L(longName)  (longName && !strcmp(name, longName))
#define _CHK_S(shortName) (!rsrc && shortName && !strcmp(name, shortName))

#define CHK_MISC(longName, shortName, func) \
	if(_CHK_L(longName) || _CHK_S(shortName)) { \
		if(!value) return(0); \
		func; \
		return(2); \
	}
#define CHK_BOOL(longName, shortName, var) \
	if(_CHK_L(longName)) { \
		if(!value) return(0); \
		var = lookupBoolean(value); \
		return(2); \
	} \
	if(_CHK_S(shortName)) { \
		var = flagSW; \
		return(1); \
	}

int	ckOpt::setOption(const char *name, const char *value, bool rsrc)
{
	bool	flagSW = true;

	if(!rsrc) {
		if(*name == '-')
			;
		else if(*name == '+')
			flagSW = false;
		else
			return(0);
		for( ; *name=='-' || *name=='+' ; name++);
	}

	CHK_MISC("foreground",		"fg",		lookupColor(value, m_colorFg));
	CHK_MISC("background",		"bg",		lookupColor(value, m_colorBg));
	CHK_MISC("cursorColor",		"cr",		lookupColor(value, m_colorCursor));
	CHK_MISC("cursorImeColor",	"cri",		lookupColor(value, m_colorCursorIme));
	CHK_MISC("backgroundBitmap",	"bitmap",	m_bgBmp = value);
	CHK_MISC("geometry",		"g",		geometry(value));
	CHK_BOOL(NULL, 			"iconic",	m_isIconic);
	CHK_MISC("font",		"fn",		m_font = value);
	CHK_MISC("fontSize",		"fs",		m_fontSize = atoi(value));
	CHK_BOOL("scrollHide",		"sh",		m_scrollHide);
	CHK_BOOL("scrollRight",		"sr",		m_scrollRight);
	CHK_MISC("saveLines",		"sl",		m_saveLines = atoi(value));
	CHK_MISC("internalBorder",	"b",		m_borderSize = atoi(value));
	CHK_MISC("lineSpace",		"lsp",		m_lineSpace = atoi(value));
	CHK_MISC("transp",		"tr",		m_transp = atoi(value));
	CHK_MISC("transpColor",		"trc",		m_isTranspColor = lookupColor(value,m_transpColor));
	CHK_BOOL("topmost",		"top",		m_isTopMost);
	CHK_MISC("chdir",		"cd",		m_curDir = value);
	CHK_MISC("exec",		"x",		m_cmd = value);
	CHK_MISC("title",		"tl",		m_title = value);
	CHK_MISC("config",		"c",		setFile(value);loadXdefaults() );


	unsigned int i;
	if(sscanf_s(name, "color%u", &i)==1 && 0<=i && i<=15) {
		if(!value) return(0);
		lookupColor(value, m_colors[i]);
		return(2);
	}
	return(0);
}

static void usage(bool isLong)
{
	static const char* str[] = {
	"foreground",		"fg",		"color",	"foreground color",
	"background",		"bg",		"color",	"background color",
	"cursorColor",		"cr",		"color",	"cursor color",
	"cursorImeColor",	"cri",		"color",	"cursor color IME-on",
	"color0",		NULL,		"color",	"",
	"color1",		NULL,		"color",	"",
	"color2",		NULL,		"color",	"",
	"color3",		NULL,		"color",	"",
	"color4",		NULL,		"color",	"",
	"color5",		NULL,		"color",	"",
	"color6",		NULL,		"color",	"",
	"color7",		NULL,		"color",	"",
	"color8",		NULL,		"color",	"",
	"color9",		NULL,		"color",	"",
	"color10",		NULL,		"color",	"",
	"color11",		NULL,		"color",	"",
	"color12",		NULL,		"color",	"",
	"color13",		NULL,		"color",	"",
	"color14",		NULL,		"color",	"",
	"color15",		NULL,		"color",	"",
	"backgroundBitmap",	"bitmap",	"string",	"background bmp file",
	"geometry",		"g",		"string",	"window layout. ( ex. 80x24+0+0 )",
	NULL, 			"iconic",	"boolean",	"start iconic",
	"font",			"fn",		"string",	"text font name",
	"fontSize",		"fs",		"number",	"text font size",
	"scrollHide",		"sh",		"boolean",	"turn on/off scrollbar hide",
	"scrollRight",		"sr",		"boolean",	"turn on/off scrollbar right",
	"saveLines",		"sl",		"number",	"save lines",
	"internalBorder",	"b",		"number",	"internal border in pixels",
	"lineSpace",		"lsp",		"number",	"number of extra pixels between rows",
	"transp",		"tr",		"number",	"alpha 0 ~ 255",
	"transpColor",		"trc",		"color",	"color key",
	"topmost",		"top",		"boolean",	"always on top",
	"chdir",		"cd",		"string",	"set current dir",
	"exec",			"x",		"string",	"exec shell",
	"title",		"tl",		"string",	"window title",
	"config",		"c",		"string",	"configration file",
	};
	unsigned int	i;

	fprintf(stdout, "%s",
		"ckw version " VERSION_STRING " , build " BUILDDATE_STRING "\n"
		COPYRIGHT_STRING "\n"
		"\n"
		"Usage: ckw [options] [-c configration file] [-e command args]\n"
		"\n");

	if(isLong) {
		fprintf(stdout, "%s", "where resources (long-options) include:\n");
		for(i = 0 ; i < sizeof(str)/sizeof(str[0]) ; i+=4)
			usage_fmtL(str[i+0], str[i+2]);
		fprintf(stdout, "\n%s\n", "  -help to list options\n");
	}
	else {
		fprintf(stdout, "%s", "where options include:\n");
		for(i = 0 ; i < sizeof(str)/sizeof(str[0]) ; i+=4)
			usage_fmtS(str[i+1], str[i+2], str[i+3]);
		fprintf(stdout, "\n%s\n", "  --help to list long-options\n");
	}
}

void	ckOpt::_loadXdefaults(const char *path)
{
	char	buf[512];
	FILE	*fp;
	std::string app, name, value;

	fopen_s(&fp, path, "r");
	if(!fp) return;

	do {
		buf[0] = buf[sizeof(buf)-1] = 0;
		fgets(buf, sizeof(buf)-2, fp);
		if(!buf[0] || buf[0] == '!')
			continue;

		extract(buf, app, name, value);

		if(name.size() < 1 || value.size() < 1)
			continue;
		if(app.size() > 0 && strcasecmp(app.c_str(), "Ckw"))
			continue;

		setOption(name.c_str(), value.c_str(), true);
	} while(!feof(fp));
	fclose(fp);
}

void	ckOpt::setFile(const char *path /*=NULL*/)
{
    if(path)
    {
        strcpy_s(m_config_file, path);
    } else
    {
        m_config_file[0] = '\0';
    }
}

static bool getconfigfile(const char* env, char *cfgfile, char *path, int size)
{
	if(GetEnvironmentVariableA(env, path, size)) {
		sprintf_s(path, size, "%s\\%s", path, cfgfile);
		if(PathFileExistsA(path) && !PathIsDirectoryA(path)) {
			return true;
		}
	}
	return false;
}

void ckOpt::loadXdefaults()
{
  char path[MAX_PATH+1];

  if(m_config_file[0] == '\0')
  {
    char cfgfile[MAX_PATH] = "_";

    if (0 != GetModuleFileNameA(NULL, path, MAX_PATH)) {
		char szDrive[MAX_PATH];
		char szDir[MAX_PATH];
		char szFile[MAX_PATH];
		char szBuf[MAX_PATH];
		_splitpath_s(path, szDrive, szDir, szFile, szBuf);
		strcat_s(cfgfile, szFile);

		path[0] = '\0';
		// HOME or USERPROFILE
		if (!getconfigfile("HOME", cfgfile, path, MAX_PATH)) {
		  getconfigfile("USERPROFILE", cfgfile, path, MAX_PATH);
		}
		if (path[0] != '\0') _loadXdefaults(path);

		// directory execute exists
		_makepath_s(path, szDrive, szDir, cfgfile, NULL);
		_loadXdefaults(path);
		_makepath_s(path, szDrive, szDir, szFile, ".cfg");
		_loadXdefaults(path);
    }
  }
  else
  {
    path[0] = '\0';
    strcpy_s(path, m_config_file);
    _loadXdefaults(path);
  }

  if(GetEnvironmentVariableA("HOME", path, MAX_PATH)) {
    strcat_s(path, "\\.Xdefaults");
    _loadXdefaults(path);
  }
}

bool	ckOpt::set(int argc, char *argv[])
{
	int	skip;
	int	i = 1;

	while(i < argc) {
		if(strcmp("-e", argv[i]) == 0) {
			if(++i >= argc) {
				usage(false);
				return(false);
			}
			cmdsMake(argc-i, argv+i);
			return(true);
		}
		if(strcmp("-help", argv[i]) == 0) {
			usage(false);
			return(false);
		}
		if(strcmp("--help", argv[i]) == 0) {
			usage(true);
			return(false);
		}

		skip = setOption(argv[i], (i+1<argc) ? argv[i+1] : NULL, false);
		if(skip < 1) {
			usage(false);
			return(false);
		}
		i += skip;
	}
	return(true);
}

/* EOF */
