
#include "core.h"

void Initialize_ProgrammableInterruptController(void)
{
	/*
	IRRFC^vgNGXgWX^ 
		.IRQs̏Ԃ\B|[gǂ񂾂ƂɁAIRRɂȂ邩ISRɂȂ邩́AOCW3őIB
		.1ɂȂĂrbǵAݗvĂi͏́j荞݁B
	ISRFCT[rXWX^ 
		.ݏ̊荞݂ǂł邩B|[gǂ񂾂ƂɁAIRRɂȂ邩ISRɂȂ邩́AOCW3őIB
		.1ɂȂĂrbǵAݏ̊荞݁BƂ̂́ACPUɑ΂INT߂𔭍sAEOIi荞ݏI߁j󂯎ĂȂ荞݁B
	IMRFC^vg}XNWX^ 
		.ꂪ1ɂȂĂ銄荞݂́AIRR1ɂȂĂĂAȂB 
	*/

	IO_Out8(PIC0_IMR, 0xff);	/*荞ݑSi}X^j*/
	IO_Out8(PIC1_IMR, 0xff);	/*荞ݑSiX[uj*/

	IO_Out8(PIC0_ICW1, 0x11);	/*GbWgK[hɐݒi}X^j*/
	IO_Out8(PIC0_ICW2, 0x20);	/*荞ݔԍA20~27ɐݒBi}X^j*/
	IO_Out8(PIC0_ICW3, 1 << 2);	/*00000100 ܂AX[uIRQ2ɂȂĂ܂ƂƁB*/
	IO_Out8(PIC0_ICW4, 0x01);	/*mobt@[hi}X^j*/

	IO_Out8(PIC1_ICW1, 0x11);	/*GbWgK[hɐݒiX[uj*/
	IO_Out8(PIC1_ICW2, 0x28);	/*荞ݔԍA28~2fɐݒBiX[uj*/
	IO_Out8(PIC1_ICW3, 2);		/*̓}X^IRQ2ԂɂȂĂ܂ƂƁB*/
	IO_Out8(PIC1_ICW4, 0x01);	/*mobt@[hiX[uj*/

	IO_Out8(PIC0_IMR, 0xff);	/*荞ݑSi}X^j*/
	IO_Out8(PIC1_IMR, 0xff);	/*荞ݑSiX[uj*/

	System_GateDescriptor_Set(0x27, (uint)asm_InterruptHandler27, 0x02, AR_INTGATE32);	/*IRQ-07΍*/
	ProgrammableInterruptController_InterruptMask_Clear(0x07);

	return;
}

void ProgrammableInterruptController_InterruptMask_Clear(uint irq)
{
	uint mask;

	mask = 1;

	if(irq >= 16){
		return;
	}

	if(irq < 8){	/*For Master*/
		IO_Out8(PIC0_IMR, IO_In8(PIC0_IMR) & ~(mask << irq));
	} else{	/*For Slave*/
		irq -= 8;
		IO_Out8(PIC1_IMR, IO_In8(PIC1_IMR) & ~(mask << irq));
		IO_Out8(PIC0_IMR, IO_In8(PIC0_IMR) & ~(mask << 2));
	}

	return;
}

void ProgrammableInterruptController_InterruptRequest_Complete(uint irq)
{
	if(irq >= 16){
		return;
	}

	if(irq < 8){	/*For Master*/
		IO_Out8(PIC0_OCW2, 0x60 + irq);
	} else{	/*For Slave (and Master IRQ2)*/
		irq -= 8;
		IO_Out8(PIC1_OCW2, 0x60 + irq);
		IO_Out8(PIC0_OCW2, 0x60 + 0x02);
	}
	return;
}

void InterruptHandler27(uint *esp)
{
	ProgrammableInterruptController_InterruptRequest_Complete(0x07);
	return;
}
