package chemicraft.client;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import chemicraft.CommonProxy;
import chemicraft.ContainerScienceCraftingTable;
import chemicraft.GuiScienceCraftingTable;
import chemicraft.TileEntityScienceCraftingTable;
import cpw.mods.fml.client.FMLClientHandler;

public class ClientProxy extends CommonProxy
{

	@Override
	public void registerRenderInformation()
	{

	}

	@Override
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
	{
		if(!world.blockExists(x, y, z)) return null;

		TileEntity tileEntity = world.getBlockTileEntity(x, y, z);

		if(tileEntity instanceof TileEntityScienceCraftingTable){
			return new GuiScienceCraftingTable(player.inventory, (TileEntityScienceCraftingTable)tileEntity);
		}
		return null;
	}

	@Override
	public World getClientWorld()
	{
		return FMLClientHandler.instance().getClient().theWorld;
	}

}
