package chemicraft;

import java.util.ArrayList;

import net.minecraft.src.GuiContainer;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Slot;

import org.lwjgl.opengl.GL11;

import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.asm.SideOnly;

@SideOnly(Side.CLIENT)
public class GuiScienceCraftingTable extends GuiContainer
{

	private ArrayList<ChemiCraftTabs> tabList = new ArrayList<ChemiCraftTabs>();

	public GuiScienceCraftingTable(InventoryPlayer par1InventoryPlayer, TileEntityScienceCraftingTable par2)
	{
		super(new ContainerScienceCraftingTable(par1InventoryPlayer, par2));
	}

	@Override
	protected void drawGuiContainerForegroundLayer()
	{
		//this.fontRenderer.drawString(StatCollector.translateToLocal("container.crafting"), 28, 6, 4210752);
		//this.fontRenderer.drawString(StatCollector.translateToLocal("container.inventory"), 8, this.ySize - 96 + 2, 4210752);
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3)
	{
		int var4 = this.mc.renderEngine.getTexture("/ChemiCraft/guis/Decomposition.png");
		int var7 = this.mc.renderEngine.getTexture("/gui/allitems.png");
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		this.mc.renderEngine.bindTexture(var4);
		int var5 = (this.width - this.xSize) / 2;
		int var6 = (this.height - this.ySize) / 2;
		this.drawTexturedModalRect(var5, var6, 0, 0, this.xSize, this.ySize);

		for(int i = 0;i < tabList.size();i++){
			this.mc.renderEngine.bindTexture(var7);
			int var8 = var5 + tabList.get(i).getID() * 28;
			int var9 = var6 - 32;
			this.drawTexturedModalRect(var8, var9, 0, 0, 28, 32);
		}
	}

	@Override
	protected void handleMouseClick(Slot par1Slot, int par2, int par3, boolean par4){
		System.out.println(par2);
		System.out.println(par3);
	}

	@Override
	protected void mouseClicked(int par1, int par2, int par3)
	{
		super.mouseClicked(par1, par2, par3);
	}

	private void addTabs(int id, int Texture, String name){
		for(int i = 0;i < tabList.size();i++){
			if(id == tabList.get(i).getID()){
				try {
					throw new Exception("ChemiCraft内でエラー:ChemiCraftTabのIDが重複しています");
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		tabList.add(new ChemiCraftTabs(id, Texture, name));
	}

}
