package pcc.chemicraft.testcase;

import static org.junit.Assert.*;

import net.minecraft.item.ItemStack;

import org.junit.Test;

import pcc.chemicraft.base.ChemiCraftBase;
import pcc.chemicraft.core.inventory.InventoryChemicalCraftingMaterial;
import pcc.chemicraft.util.ChemicalNBTRecipe;
import pcc.chemicraft.util.MaterialRecipe;

public class MaterialRecipeTest extends MaterialRecipe {

	public MaterialRecipeTest() {
		super(
				new ItemStack(1800, 1, 0),
				new ItemStack[] {
					new ItemStack(1800, 1, 0)
				},
				null,
				true);
	}

	@Test
	public void test() {

		ItemStack stack = new ItemStack(18000, 1, 0);
		InventoryChemicalCraftingMaterial inv = new InventoryChemicalCraftingMaterial();
		inv.setInventorySlotContents(0, new ItemStack(18000, 1, 0));

		MaterialRecipe mr = new MaterialRecipe(
				stack,
				new ItemStack[] {
						new ItemStack(18000, 1, 0)
				},
				null,
				true);

		assertEquals(
				mr.match(inv),
				stack
				);

	}

}
