package pcc.chemicraft.core;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import pcc.chemicraft.core.item.ItemAtoms;
import pcc.chemicraft.core.item.ItemChemiCell;
import pcc.chemicraft.core.item.ItemCompounds;
import pcc.chemicraft.core.item.ItemGasCollectingBottle;
import pcc.chemicraft.util.OldItemFood;

public class ChemiCraftRegisterItem extends ChemiCraftCoreRegister {

	public ChemiCraftRegisterItem(ChemiCraftCore mod) {
		super(mod);
	}

	@Override
	public void start() {
		/*
		 * 代入
		 */
		this.mod.itemAtoms = new ItemAtoms(this.mod.atomsID).setItemName("atoms");
		this.mod.itemCompounds = new ItemCompounds(this.mod.compoundsID).setItemName("compounds");
		this.mod.itemGasCollectingBottle = new ItemGasCollectingBottle(this.mod.gasCollectingBottleID).setItemName("gasCollectingBottle").setIconIndex(0);
		this.mod.itemChemicalCells = new ItemChemiCell(this.mod.chemicalCellsID).setItemName("chemiCell").setIconIndex(3);
		this.mod.itemPear = new OldItemFood(this.mod.pearID, 4, 0.4F, false){
			public int getColorFromItemStack(ItemStack par1ItemStack,int par2){
				return 0x66FF66;
				}
			}.setIconIndex(11).setCreativeTab(CreativeTabs.tabFood).setItemName("Pear");

		/*
		 * 名前登録&Minecraftに登録
		 */
		this.mod.nameAuxiliary.addName(this.mod.itemAtoms, ChemiCraftCore.ATOMSNAME);
		this.mod.nameAuxiliary.addName(this.mod.itemAtoms, "ja_JP", ChemiCraftCore.ATOMSNAMEJP);
		this.mod.nameAuxiliary.addName(this.mod.itemGasCollectingBottle, "GasCollectingBottle");
		this.mod.nameAuxiliary.addName(this.mod.itemGasCollectingBottle, "ja_JP", "集気瓶");
		this.mod.nameAuxiliary.addName(this.mod.itemChemicalCells, "ChemicalCell");
		this.mod.nameAuxiliary.addName(this.mod.itemChemicalCells, "ja_JP",  "化学電池");
		this.mod.api.addElectrolysisDecompositionFuel(new ItemStack(this.mod.itemChemicalCells), 1000);
		this.mod.nameAuxiliary.addName(this.mod.itemPear, "Pear");
		this.mod.nameAuxiliary.addName(this.mod.itemPear, "ja_JP",  "梨");

	}

}
