package pcc.chemicraft.base.ore;

import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import pcc.chemicraft.base.ChemiCraftBase;
import pcc.chemicraft.core.ChemiCraftCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class BlockAtomOres extends Block
{

	public BlockAtomOres(int id)
	{
		super(id, Material.rock);
		this.setCreativeTab(ChemiCraftBase.instance.creativeTabAtomsOre);
	}

	@Override
	public int getBlockTextureFromSideAndMetadata(int par1, int par2)
	{
		return (this.blockID - ChemiCraftBase.instance.atomOresID[0]) * 16 + par2;
	}

	@Override
	public int damageDropped(int par1)
	{
		return par1;
	}

	public static int getBlockFromDye(int par0)
	{
		return ~par0 & 15;
	}

	public static int getDyeFromBlock(int par0)
	{
		return ~par0 & 15;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List)
	{
		for (int var4 = 0; var4 < 16; ++var4) {
			par3List.add(new ItemStack(par1, 1, var4));
		}
	}

	@Override
	public String getTextureFile()
	{
		return ChemiCraftCore.instance.BLOCK_ATOMS_ORE_TEXTURE;
	}

}
