package pcc.chemicraft.base;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import pcc.chemicraft.core.ChemiCraftCore;
import pcc.chemicraft.util.Formula;
import pcc.chemicraft.util.NBTRecipeGrenade;

public class ChemiCraftRegisterBaseRecipe extends ChemiCraftBaseRegister {

	public ChemiCraftRegisterBaseRecipe(ChemiCraftBase mod) {
		super(mod);
	}

	@Override
	public void start() {

		/*
		 * 化合物のレシピ
		 */
		this.mod.api.addChemicalCombinationRecipe(new ItemStack(ChemiCraftCore.instance.itemCompounds, 1, this.mod.api.getCompound("SodiumChloride")), new Formula("NaOH"));
		this.mod.api.addChemicalCombinationRecipe(new ItemStack(ChemiCraftCore.instance.itemCompounds, 1, this.mod.api.getCompound("ChlorousAcid")), new Formula("HO2Cl"));

		/*
		 * 既存物のレシピ
		 */
		// Block
		this.mod.api.addReversibleOfPyrolysis(new ItemStack(Block.stone), new Formula("SiO2"));
		this.mod.api.addReversibleOfPyrolysis(new ItemStack(Block.dirt), new Formula("SiI2O2"));
		this.mod.api.addReversibleOfElectrolysis(new ItemStack(Block.wood), new Formula("C6H10O5"));
		this.mod.api.addReversibleOfPyrolysis(new ItemStack(Block.glass), new Formula("SiCO2"));
		this.mod.api.addReversibleOfPyrolysis(new ItemStack(Block.tnt), new Formula("C7H5N3O6"));

		// Item
		this.mod.api.addElectrolysisDecompositionRecipe(new ItemStack(Item.bucketWater), new Formula("H2O"));
		this.mod.api.addElectrolysisDecompositionRecipe(new ItemStack(Item.potion, 1, 0), new Formula("H2O"));
		this.mod.api.addChemicalCombinationRecipe(new ItemStack(Item.sugar), new Formula("C12H22O11"));

		// 鉱石
		this.mod.api.addPyrolysisDecompositionRecipe(new ItemStack(Block.oreCoal), new Formula("C"));
		this.mod.api.addPyrolysisDecompositionRecipe(new ItemStack(Item.coal), new Formula("C"));
		this.mod.api.addChemicalCombinationRecipe(new ItemStack(Item.diamond), 
				new Formula("C64Si16"));
		this.mod.api.addReversibleOfPyrolysis(new ItemStack(Item.emerald), new Formula("Be3Al2Si6O18"));

		/*
		 * 他Mod使用時レシピ
		 */
		this.mod.api.addPyrolysisDecompositionRecipe(
				OreDictionary.getOres("oreCopper"), new Formula("Cu"));

		/*
		 * 素材制作代のレシピ
		 */
		//手榴弾の追加
		this.mod.api.addMaterialRecipe(new ItemStack[] {
				null,
				new ItemStack(Block.stone),
				null,
				new ItemStack(Block.stone),
				new ItemStack(Item.gunpowder),
				new ItemStack(Block.stone),
				null,
				new ItemStack(Block.stone),
				null
		},
		new ItemStack(this.mod.itemAtomGrenade, 16, 0),
		new NBTRecipeGrenade()
				);

		this.mod.api.addSharplessMaterialRecipe(new ItemStack[] {
				new ItemStack(this.mod.itemAtomGrenade, 1, 0),
		},
		new ItemStack(this.mod.itemAtomGrenade, 1, 0),
		new NBTRecipeGrenade()
				);

		/*
		 * 分解台のレシピ
		 */
		this.mod.api.addElectrolysisDecompositionRecipe(new ItemStack(ChemiCraftCore.instance.itemCompounds, 1, this.mod.api.getCompound("Water")),
				new Formula("H2O"));

		for (int i = 0; i < this.mod.apiBase.getAtomOresName().sizeKeysList(); i++){
			this.mod.api.addPyrolysisDecompositionRecipe(new ItemStack(this.mod.blockAtomOres[i / 16], 1, i - i / 16 * 16),
			this.mod.apiBase.getAtomOresFormulas().get(this.mod.apiBase.getAtomOresName().getKeyList(i)));
		}


	}

}
