package pcc.chemicraft;

import pcc.chemicraft.core.ChemiCraftAPI;
import pcc.chemicraft.util.Auxiliary;
import pcc.chemicraft.util.Auxiliary.ArrayAuxiliary;
import pcc.chemicraft.util.Auxiliary.MathAuxiliary;
import pcc.chemicraft.util.Auxiliary.NameAuxiliary;
import cpw.mods.fml.common.event.FMLStateEvent;

public abstract class ChemiCraft implements Runnable
{

	/**
	 * this is Thread on ChemiCraft.
	 */
	protected Thread thread;

	/**
	 * the Event Instance.
	 */
	protected FMLStateEvent event;

	/**
	 * API Instance and Data Instance.
	 */
	public ChemiCraftAPI api = ChemiCraftAPI.instance();
	public static final ChemiCraftData chemicalData = new ChemiCraftData();

	/**
	 *These Instances required on ChemiCraft.
	 */
	public Auxiliary auxiliary = new Auxiliary();
	public NameAuxiliary nameAuxiliary = new NameAuxiliary();
	public ArrayAuxiliary arrayAuxiliary = new ArrayAuxiliary();
	public MathAuxiliary mathAuxiliary = new MathAuxiliary();

	/**
	 * this is Textures Path on ChemiCraft.
	 */
	public static final String ITEM_ATOMS_TEXTURE = "/pcc/chemicraft/items/Atoms.png";
	public static final String ITEM_COMPOUNDS_TEXTURE = "/pcc/chemicraft/items/Compounds.png";
	public static final String ITEM_VEGETABLES_TEXTURE = "/pcc/chemicraft/items/Vegetables.png";
	public static final String ITEM_TEXTURE = "/pcc/chemicraft/items/items.png";
	public static final String BLOCK_CHEMICAL_CRAFTING_TABLE_TEXTURE = "/pcc/chemicraft/blocks/cctable.png";
	public static final String BLOCK_ATOMS_ORE_TEXTURE = "/pcc/chemicraft/blocks/AtomsOre.png";
	public static final String BLOCK_VEGETABLES_TEXTURE = "/pcc/chemicraft/blocks/Vegetables.png";
	public static final String GUI_PYROLYSIS_TEXTURE = "/pcc/chemicraft/guis/Pyrolysis.png";
	public static final String GUI_ELECTROLYSIS_TEXTURE = "/pcc/chemicraft/guis/Electrolysis.png";
	public static final String GUI_CHEMICALCOMBINATION_TEXTURE = "/pcc/chemicraft/guis/ChemicalCombination.png";
	public static final String GUI_TOOLANDWEAPONCRAFTING_TEXTURE = "/pcc/chemicraft/guis/ToolAndWeaponCrafting.png";
	public static final String GUI_CHEMICALCRAFTING_TEXTURE = "/pcc/chemicraft/guis/MaterialCrafting.png";
	public static final String ENTITY_PARTICLE_TEXRURE = "/pcc/chemicraft/entityParticles/dust.png";

}