package chemicraft;

import java.util.ArrayList;

import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;

public class NBTRecipeGrenade extends NBTRecipe {

	@Override
	public ItemStack[] setNBT(ItemStack[] materials, ItemStack result) {

		ItemStack[] useItems = new ItemStack[3];

		if(result.stackTagCompound == null){
			result.stackTagCompound = new NBTTagCompound();
		}

		if (!result.stackTagCompound.hasKey("Effect"))
		{
			result.stackTagCompound.setTag("Effect", new NBTTagList("Effect"));
		}

		NBTTagList tagList = (NBTTagList) result.getTagCompound().getTag("Effect");
		NBTTagCompound tag = new NBTTagCompound();
		boolean isAssignment = false;
		boolean var1 = false;

		for(int i = 0;i < materials.length;i++){
			if(materials[i] != null){
				if(materials[i].itemID-256 == ChemiCraft.instance.atomsID && materials[i].getItemDamage() == ChemiCraft.HYDROGEN){
					tag.setString("GrenadeEffect" + i, "Hydrogen");
					useItems[i] = materials[i];
					isAssignment = true;
					var1 = true;
				}
				if(materials[i].itemID-256 == ChemiCraft.instance.atomsID && materials[i].getItemDamage() == ChemiCraft.CARBON){
					tag.setString("GrenadeEffect" + i, "Carbon");
					useItems[i] = materials[i];
					isAssignment = true;
					var1 = true;
				}
				if(materials[i].itemID-256 == ChemiCraft.instance.atomsID && materials[i].getItemDamage() == ChemiCraft.URANIUM){
					tag.setString("GrenadeEffect" + i, "Uranium");
					useItems[i] = materials[i];
					isAssignment = true;
					var1 = true;
				}
			}
			if(!var1) materials[i] = null;
			var1 = false;
		}
		tagList.appendTag(tag);
		if(!isAssignment) result.stackTagCompound = null;
		return useItems;
	}

}
