package chemicraft;

import java.util.List;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.World;

public class ItemAtomGrenade extends Item {

	protected ItemAtomGrenade(int par1) {
		super(par1);
	}

	public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer){
		if(par1ItemStack.stackSize <= 0){
			return null;
		}

		boolean var1 = false;
		boolean var2 = false;
		boolean var3 = false;

		NBTTagList var4 = par1ItemStack.getTagCompound().getTagList("Effect");

		for(int i = 0;i < 3;i++){
			if(!((NBTTagCompound)var4.tagAt(0)).getString("GrenadeEffect" + i).equals("")){
				if(((NBTTagCompound)var4.tagAt(0)).getString("GrenadeEffect" + i).equals("Hydrogen")){
					var1 = true;
				}
				if(((NBTTagCompound)var4.tagAt(0)).getString("GrenadeEffect" + i).equals("Carbon")){
					var2 = true;
				}
				if(((NBTTagCompound)var4.tagAt(0)).getString("GrenadeEffect" + i).equals("Uranium")){
					var3 = true;
				}
			}
		}

		EntityAtomGrenade entity = new EntityAtomGrenade(par2World, par3EntityPlayer, var1, var2, var3);
		par2World.spawnEntityInWorld(entity);
		par1ItemStack.stackSize--;
		return par1ItemStack;
	}

	@Override
	public void addInformation(ItemStack par1ItemStack, List par2List) {
		if(par1ItemStack.getTagCompound() != null){
			NBTTagList var1 = par1ItemStack.getTagCompound().getTagList("Effect");

			for(int i = 0;i < 3;i++){
				if(!((NBTTagCompound)var1.tagAt(0)).getString("GrenadeEffect" + i).equals("")){
					par2List.add(
							((NBTTagCompound)var1.tagAt(0)).getString("GrenadeEffect" + i)
							);
				}
			}
		}
	}

	@Override
	public String getTextureFile(){
		return "/chemicraft/items/items.png";
	}

}
