package chemicraft;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.World;
import cpw.mods.fml.common.network.PacketDispatcher;

public class ContainerDecompositionTable extends Container {

	/**
	 * Worldのインスタンス
	 */
	private World worldObj;


	/**
	 * BlockのX, Y, Z座標
	 */
	private int posX;
	private int posY;
	private int posZ;


	/**
	 * the TileEntity.
	 */
	private TileEntityDecompositionTable tileEntity;


	/**
	 * the inventory.
	 */
	private InventoryDecomposition inv;



	/**
	 * the inventoryPlayer.
	 */
	private InventoryPlayer invp;



	public ContainerDecompositionTable(EntityPlayer par1EntityPlayer, TileEntityDecompositionTable par2)
	{
		super();
		this.worldObj = par2.worldObj;
		this.posX = par2.xCoord;
		this.posY = par2.yCoord;
		this.posZ = par2.zCoord;
		this.tileEntity = par2;
		this.inv = par2.getInventorys();
		this.invp = par1EntityPlayer.inventory;
		//GenerateInventory
		this.generateSlots("Decomposition", par2.getInventorys());
		//GeneratePlayerInventory
		int var3;

		for (var3 = 0; var3 < 3; ++var3)
		{
			for (int var4 = 0; var4 < 9; ++var4)
			{
				this.addSlotToContainer(new Slot(par1EntityPlayer.inventory, var4 + var3 * 9 + 9, 8 + var4 * 18, 85 + var3 * 18));
			}
		}

		for (var3 = 0; var3 < 9; ++var3)
		{
			this.addSlotToContainer(new Slot(par1EntityPlayer.inventory, var3, 8 + var3 * 18, 143));
		}

		this.tileEntity.getInventorys().setEventHandler(this);
	}



	@Override
	public void onCraftMatrixChanged(IInventory par1IInventory){
		if(ChemiCraftAPI.instance.getCraftingManager().getDecompositionResults(this.inv) != null){
			for(int i = 0;i < ChemiCraftAPI.instance.getCraftingManager().getDecompositionResults(this.inv).length;i++){
				this.inv.setInventorySlotContents(i, ChemiCraftAPI.instance.getCraftingManager().getDecompositionResults(this.inv)[i]);
			}
		}
		this.inv.setFlag(true);
	}



	@Override
	public void updateCraftingResults(){
		super.updateCraftingResults();
	}



	@Override
	public void onCraftGuiClosed(EntityPlayer par1EntityPlayer){
		super.onCraftGuiClosed(par1EntityPlayer);
	}



	@Override
	public boolean canInteractWith(EntityPlayer par1EntityPlayer){
		return this.worldObj.getBlockId(this.posX, this.posY, this.posZ) != ChemiCraft.instance.decompositionTableID ? false : par1EntityPlayer.getDistanceSq((double)this.posX + 0.5D, (double)this.posY + 0.5D, (double)this.posZ + 0.5D) <= 64.0D;
	}



	@Override
	public ItemStack slotClick(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer)
	{
		if(par1 < 16){
			return null;
		}else{
			super.slotClick(par1, par2, par3, par4EntityPlayer);
		}
		return null;
	}



	@Override
	public ItemStack transferStackInSlot(int par1){
		return null;
	}



	public void onButtonClick(int par1){
		if(par1 == 0){
			if(this.inv.getStackInSlot(16) != null){
				for(int loop = 0;loop < this.inv.getStackInSlot(16).stackSize;loop++){
					if(this.invp.player.inventory.getFirstEmptyStack() != -1){
						this.tileEntity.setItemDrop(false);
						this.tileEntity.setButtonClick(true);
						PacketDispatcher.sendPacketToServer(this.tileEntity.getDescriptionPacket());
						this.tileEntity.setButtonClick(false);
					}else{
						this.tileEntity.setItemDrop(true);
						this.tileEntity.setButtonClick(true);
						PacketDispatcher.sendPacketToServer(this.tileEntity.getDescriptionPacket());
						this.tileEntity.setButtonClick(false);
					}
				}
			}
		}
	}



	private void generateSlots(String activeTabs, IInventory inventorys){
		int count = 0;
		for(int i = 0;i < 4;i++){
			for(int j = 0;j < 4;j++){
				this.addSlotToContainer(new SlotDecompositionResult(inventorys, count, 90 + 18 * j, 8 + 18 * i));
				count++;
			}
		}
		this.addSlotToContainer(new Slot(inventorys, count, 28, 30));
	}

}
