package chemicraft;

import java.util.ArrayList;
import java.util.Collections;

import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;

public class ChemiCraftCraftingManager {

	public ItemStack[] getDecompositionResults(IInventory par1IInventory){
		//Setting to Flag.
		((InventoryDecomposition)par1IInventory).setFlag(false);

		//variable of results.
		ItemStack[] results = null;

		//Just loop of amount of added recipe.
		for(int i1 = 0;i1 < ChemiCraftAPI.instance.getDecompositionMaterial().size();i1++){
			//Recipe the match?
			boolean match = true;
			//Reset the results.
			results  = new ItemStack[ChemiCraftAPI.instance.getDecompositionResult().get(i1).length];
			//Recipe ID & Damage.
			//Material ID & Damage.
			int materialID = par1IInventory.getStackInSlot(16).itemID;
			int materialDamage = par1IInventory.getStackInSlot(16).getItemDamage();
			int recipeID = ChemiCraftAPI.instance.getDecompositionMaterial().get(i1).itemID;
			int recipeDamage = ChemiCraftAPI.instance.getDecompositionMaterial().get(i1).getItemDamage();

			//Check of null of the Material Slot.
			if(par1IInventory.getStackInSlot(16) == null){ this.clearResults(par1IInventory, 16); return new ItemStack[16];}
			//ID check.
			if(materialID != recipeID){ match = false;}
			//Damage check.
			if(materialDamage != recipeDamage){ match = false;}

			//if "match == true"
			if(match){
				//Just loop of recipe size of recipe index i1.
				for(int i = 0;i < ChemiCraftAPI.instance.getDecompositionResult().get(i1).length;i++){
					//Assignment to the results.
					results[i] = new ItemStack(
							ChemiCraftAPI.instance.getDecompositionResult().get(i1)[i].itemID,
							ChemiCraftAPI.instance.getDecompositionResult().get(i1)[i].stackSize,
							ChemiCraftAPI.instance.getDecompositionResult().get(i1)[i].getItemDamage()
							);
				}
				//return the results.
				return results;
			}
		}
		//return the null.
		return null;
	}



	public ItemStack getChemicalCombinationResult(IInventory par1IInventory){
		//Setting to flag.
		((InventoryChemicalCombination) par1IInventory).setFlag(false);

		//variable of result.
		ItemStack result = null;

		//Just loop of amount of added recipe.
		for(int i = 0;i < ChemiCraftAPI.instance.getChemicalCombinationMaterial().size();i++){

			//Recipe the match?
			boolean match = true;
			//materialID & recipeID
			ArrayList<Integer> materialID = new ArrayList<Integer>();
			ArrayList<Integer> materialDamage = new ArrayList<Integer>();
			ArrayList<Integer> recipeID = new ArrayList<Integer>();
			ArrayList<Integer> recipeDamage = new ArrayList<Integer>();

			//Just loop of recipe size of recipe index i.
			for(int j = 0;j < ChemiCraftAPI.instance.getChemicalCombinationMaterial().get(i).length;j++){
				//Adding the recipe ID & Damage.
				recipeID.add(ChemiCraftAPI.instance.getChemicalCombinationMaterial().get(i)[j].itemID);
				recipeDamage.add(ChemiCraftAPI.instance.getChemicalCombinationMaterial().get(i)[j].getItemDamage());
			}
			//Just loop of 16.
			for(int j = 0;j < 16;j++){
				//Null check
				if(par1IInventory.getStackInSlot(j) != null){
					//Adding the materialID & Damage.
					materialID.add(par1IInventory.getStackInSlot(j).itemID);
					materialDamage.add(par1IInventory.getStackInSlot(j).getItemDamage());
				}
			}

			//trimToSize & sorting.
			materialID.trimToSize();
			materialDamage.trimToSize();
			recipeID.trimToSize();
			recipeDamage.trimToSize();
			Collections.sort(materialID);
			Collections.sort(materialDamage);
			Collections.sort(recipeID);
			Collections.sort(recipeDamage);

			//Size check.
			if(materialID.size() != recipeID.size()){ match = false;}
			//Just loop of materialID.size().
			for(int j = 0;j < materialID.size();j++){
				//ID check.
				if(materialID.get(j) != recipeID.get(j)){ match = false;}
				//Damage check.
				if(materialDamage.get(j) != recipeDamage.get(j)){ match = false;}
			}

			//if "match == true"
			if(match){
				//Assignment to the result.
				result =
						new ItemStack(
								ChemiCraftAPI.instance.getChemicalCombinationResult().get(i).itemID,
								ChemiCraftAPI.instance.getChemicalCombinationResult().get(i).stackSize,
								ChemiCraftAPI.instance.getChemicalCombinationResult().get(i).getItemDamage()
								);
				//return the result.
				return result;
			}
		}
		//return the null.
		return null;
	}



	public ItemStack getMaterialResult(IInventory par1IInventory){
		((InventoryMaterialCrafting) par1IInventory).setFlag(false);

		ItemStack result = null;

		for(int i = 0;i < ChemiCraftAPI.instance.getMaterialMaterials().size();i++){
			boolean match = true;

			ArrayList<Integer> materialID = new ArrayList<Integer>();
			ArrayList<Integer> materialDamage = new ArrayList<Integer>();
			ArrayList<Integer> recipeID = new ArrayList<Integer>();
			ArrayList<Integer> recipeDamage = new ArrayList<Integer>();
			ItemStack[] var1 = new ItemStack[3];

			//Just loop of recipe size of recipe index i.
			for(int j = 0;j < ChemiCraftAPI.instance.getMaterialMaterials().get(i).length;j++){
				//Adding the recipe ID & Damage.
				recipeID.add(ChemiCraftAPI.instance.getMaterialMaterials().get(i)[j].itemID);
				recipeDamage.add(ChemiCraftAPI.instance.getMaterialMaterials().get(i)[j].getItemDamage());
			}
			//Just loop of 9.
			for(int j = 0;j < 9;j++){
				//Null check
				if(par1IInventory.getStackInSlot(j+3) != null){
					//Adding the materialID & Damage.
					materialID.add(par1IInventory.getStackInSlot(j+3).itemID);
					materialDamage.add(par1IInventory.getStackInSlot(j+3).getItemDamage());
				}
			}

			for(int j = 0;j < 3;j++){
				var1[j] = par1IInventory.getStackInSlot(j);
			}

			//trimToSize & sorting.
			materialID.trimToSize();
			materialDamage.trimToSize();
			recipeID.trimToSize();
			recipeDamage.trimToSize();
			Collections.sort(materialID);
			Collections.sort(materialDamage);
			Collections.sort(recipeID);
			Collections.sort(recipeDamage);

			//Size check.
			if(materialID.size() != recipeID.size()){ match = false;}
			//Just loop of materialID.size().
			for(int j = 0;j < materialID.size();j++){
				//ID check.
				if(materialID.get(j) != recipeID.get(j)){ match = false;}
				//Damage check.
				if(materialDamage.get(j) != recipeDamage.get(j)){ match = false;}
			}

			//if "match == true"
			if(match){
				//Assignment to the result.
				result =
						new ItemStack(
								ChemiCraftAPI.instance.getMaterialResult().get(i).itemID,
								ChemiCraftAPI.instance.getMaterialResult().get(i).stackSize,
								ChemiCraftAPI.instance.getMaterialResult().get(i).getItemDamage()
								);

				if(ChemiCraftAPI.instance.getMaterialNBTRecipe().get(i) != null){
					ItemStack[] useItems = ChemiCraftAPI.instance.getMaterialNBTRecipe().get(i).setNBT(var1, result);
					((InventoryMaterialCrafting) par1IInventory).subtractStack(0, 3, useItems);
				}

				((InventoryMaterialCrafting) par1IInventory).setFlag2(false);

				//return the result.
				return result;
			}
		}

		return null;
	}



	private void clearResults(IInventory par1IInventory, int par2){
		((InventoryDecomposition)par1IInventory).setFlag(false);
		for(int i = 0;i < par2;i++){
			par1IInventory.setInventorySlotContents(i, null);
		}
	}

}
