package chemicraft;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

/**
 * いろいろなデータを格納しメソッドによってチェックするクラス
 * 使用する場合はItemAtomInfoContainerを継承することを推奨
 * @author ponkotate
 *
 */
public class AtomInfo {

	/**
	 * X, Y, Z座標
	 */
	private  int posX;
	private  int posY;
	private  int posZ;


	/**
	 * biomeの名前
	 */
	private  String biomeName;


	/**
	 * 天候
	 */
	private  String weather;


	/**
	 * EntityPlayerのインスタンス
	 */
	private EntityPlayer entityPlayer;


	/**
	 * Worldのインスタンス
	 */
	private World world;



	/**
	 * AtomInfoのデータをupdateします
	 * @param par1World Worldのインスタンス
	 * @param par2EntityPlayer EntityPlayerのインスタンス
	 */
	public void update(World par1World, EntityPlayer par2EntityPlayer){
		this.world = par1World;
		this.entityPlayer = par2EntityPlayer;

		this.posX = (int) par2EntityPlayer.posX;
		this.posY = (int) par2EntityPlayer.posY;
		this.posZ = (int) par2EntityPlayer.posZ;

		this.biomeName = par1World.getBiomeGenForCoords(posX, posZ).biomeName;

		if (par1World.isThundering()){
			this.weather = "Thunder";
		}else if(par1World.isRaining()){
			this.weather = "Rain";
		}else{
			this.weather = "Sun";
		}
	}



	/**
	 * 引数に指定されたBiomeと同等か比較します
	 * @param biomeName 比較するBiomeの名前
	 * @return Biomeが一致しているか
	 */
	public boolean isEquivalentBiome(String biomeName){
		if(this.biomeName != null){
			if(this.biomeName == biomeName){
				return true;
			}else{
				return false;
			}
		}else{
			System.err.println("AtonInfo:データが入っていません。updateメソッドでデータを入れてください");
			return false;
		}
	}



	/**
	 * 引数に指定された天候と同等か比較します
	 * 晴れ:Sun, 雨:Rain, 雷雨:Thunder
	 * @param weather 比較する天候
	 * @return 天候が一致しているか
	 */
	public boolean isEquivalentWeather(String weather){
		if(this.weather != null){
			if(this.weather == weather){
				return true;
			}else{
				return false;
			}
		}else{
			System.err.println("AtonInfo:データが入っていません。updateメソッドでデータを入れてください");
			return false;
		}
	}



	/**
	 * 引数に指定されたY軸より高いか判定します
	 * @param par1
	 * @return 指定されたY軸より高いか
	 */
	public boolean isOverY(int par1){
		if(this.posY >= par1){
			return true;
		}else{
			return false;
		}
	}



	/**
	 * 引数に指定されたY軸と同等か判定します
	 * @param par1
	 * @return 指定されたY軸と同等かどうか
	 */
	public boolean isEquivalentY(int par1){
		if(this.posY == par1){
			return true;
		}else{
			return false;
		}
	}



	/**
	 * 引数に指定されたY軸より低いか判定します
	 * @param par1
	 * @return 指定されたY軸より低いか
	 */
	public boolean isBelowY(int par1){
		if(this.posY <= par1){
			return true;
		}else{
			return false;
		}
	}

}
