package chemicraft;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import net.minecraft.src.EntityPlayer;

import net.minecraft.src.INetworkManager;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet250CustomPayload;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;

/**
 * サーバーとクライアントのデータの同期に必要なクラス
 *
 * @author Lilly
 *
 */
public class PacketHandler implements IPacketHandler {

	@Override
	public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
		if (packet.channel.equals("chemicraft")) {
			ByteArrayDataInput badi = ByteStreams.newDataInput(packet.data);

			World worldClient;
			World worldServer;
			TileEntity var1;
			TileEntityDecompositionTable var2;

			// TileEntityのx, y, z座標
			int x, y, z;

			// 座標読み込み
			x = badi.readInt();
			y = badi.readInt();
			z = badi.readInt();

			worldClient = ChemiCraft.instance.proxy.getClientWorld();
			worldServer = ((EntityPlayer)player).worldObj;
			if(worldClient != null && worldServer == null){
				var1 = worldClient.getBlockTileEntity(x, y, z);
				if (var1 instanceof TileEntityDecompositionTable) {
					var2 = (TileEntityDecompositionTable) var1;
					var2.readPacket(badi, (EntityPlayer)player);
				}
				return;
			}
			if(worldServer != null){
				var1 = worldServer.getBlockTileEntity(x, y, z);
				if (var1 instanceof TileEntityDecompositionTable) {
					var2 = (TileEntityDecompositionTable) var1;
					var2.readPacket(badi, (EntityPlayer)player);
				}
				return;
			}
		}
	}


	public static Packet getPacket(TileEntityDecompositionTable tileEntity) {
		ByteArrayOutputStream var1 = new ByteArrayOutputStream(128);
		DataOutputStream var2 = new DataOutputStream(var1);

		// Blockのx, y, z座標
		int x, y, z;

		// activeTab
		String activeTab;

		// x, y, z座標を代入
		x = tileEntity.xCoord;
		y = tileEntity.yCoord;
		z = tileEntity.zCoord;

		try {
			// 座標書き込み
			var2.writeInt(x);
			var2.writeInt(y);
			var2.writeInt(z);
			tileEntity.writePacket(var2);
		} catch (IOException e) {
			e.printStackTrace();
		}

		// パケットの作成
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "chemicraft";
		packet.data = var1.toByteArray();
		packet.length = var1.size();
		packet.isChunkDataPacket = true;
		return packet;
	}

	public static Packet getPacket(TileEntityChemicalCombinationTable tileEntity) {
		ByteArrayOutputStream var1 = new ByteArrayOutputStream(128);
		DataOutputStream var2 = new DataOutputStream(var1);

		// Blockのx, y, z座標
		int x, y, z;

		// activeTab
		String activeTab;

		// x, y, z座標を代入
		x = tileEntity.xCoord;
		y = tileEntity.yCoord;
		z = tileEntity.zCoord;

		try {
			// 座標書き込み
			var2.writeInt(x);
			var2.writeInt(y);
			var2.writeInt(z);
			tileEntity.writePacket(var2);
		} catch (IOException e) {
			e.printStackTrace();
		}

		// パケットの作成
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "chemicraft";
		packet.data = var1.toByteArray();
		packet.length = var1.size();
		packet.isChunkDataPacket = true;
		return packet;
	}

	public static Packet getPacket(TileEntityToolAndWeaponCraftingTable tileEntity) {
		ByteArrayOutputStream var1 = new ByteArrayOutputStream(128);
		DataOutputStream var2 = new DataOutputStream(var1);

		// Blockのx, y, z座標
		int x, y, z;

		// activeTab
		String activeTab;

		// x, y, z座標を代入
		x = tileEntity.xCoord;
		y = tileEntity.yCoord;
		z = tileEntity.zCoord;

		try {
			// 座標書き込み
			var2.writeInt(x);
			var2.writeInt(y);
			var2.writeInt(z);
			tileEntity.writePacket(var2);
		} catch (IOException e) {
			e.printStackTrace();
		}

		// パケットの作成
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "chemicraft";
		packet.data = var1.toByteArray();
		packet.length = var1.size();
		packet.isChunkDataPacket = true;
		return packet;
	}

	public static Packet getPacket(TileEntityMaterialCraftingTable tileEntity) {
		ByteArrayOutputStream var1 = new ByteArrayOutputStream(128);
		DataOutputStream var2 = new DataOutputStream(var1);

		// Blockのx, y, z座標
		int x, y, z;

		// activeTab
		String activeTab;

		// x, y, z座標を代入
		x = tileEntity.xCoord;
		y = tileEntity.yCoord;
		z = tileEntity.zCoord;

		try {
			// 座標書き込み
			var2.writeInt(x);
			var2.writeInt(y);
			var2.writeInt(z);
			tileEntity.writePacket(var2);
		} catch (IOException e) {
			e.printStackTrace();
		}

		// パケットの作成
		Packet250CustomPayload packet = new Packet250CustomPayload();
		packet.channel = "chemicraft";
		packet.data = var1.toByteArray();
		packet.length = var1.size();
		packet.isChunkDataPacket = true;
		return packet;
	}

}
