package chemicraft;

import java.util.List;

import net.minecraft.src.CreativeTabs;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.asm.SideOnly;

public class ItemAtoms extends Item {

    public ItemAtoms(int par1) {
        super(par1);
        this.maxStackSize = 1;
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setCreativeTab(ChemiCraft.instance.creativeTab);
    }

    @SideOnly(Side.CLIENT)
    @Override
    public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List)
    {
        for(int type = 0; type < ChemiCraft.atomsName.length; type++)
        {
              par3List.add(new ItemStack(par1, 1, type));
              this.setIconIndex(type);
        }
    }

    @Override
    public String getItemNameIS(ItemStack par1ItemStack)
    {
        return super.getItemName() + "." + ChemiCraft.atomsName[par1ItemStack.getItemDamage()];
    }

    @Override
    public String getTextureFile()
    {
        this.isDefaultTexture = false;
        return "/ChemiCraft/items/Atoms.png";
    }

    @SideOnly(Side.CLIENT)
    @Override
    public int getIconFromDamage(int par1)
    {
        return par1;
    }

}