package chemicraft;

import java.util.ArrayList;

public class ChemiCraftAPI {

	/**
	 * Instance of the ChemiCraftAPI.
	 */
	public static ChemiCraftAPI instance = new ChemiCraftAPI();

	/**
	 * List of compounds names.
	 */
	private static ArrayList<String> compoundsNameList = new ArrayList();

	/**
	 * List of compounds names(Some kind of language).
	 */
	private static ArrayList<String> compoundsLangNameList = new ArrayList();

	/**
	 * List of compounds the language names.
	 */
	private static ArrayList<String> compoundsLangList = new ArrayList();

	/**
	 * List of compounds handlers.
	 */
	private static ArrayList<ICompoundHandler> compoundHandlers = new ArrayList<ICompoundHandler>();

	/**
	 * List of item name of handler to compounds.
	 */
	private static ArrayList<String> compoundHandlerItemNames = new ArrayList<String>();

	/**
	 * add compound.
	 * @param name compound name.
	 */
	public static void addCompound(String name){
		compoundsNameList.add(name);
		compoundsLangNameList.add("");
		compoundsLangList.add("");
	}

	/**
	 * add compound corresponding to the language.
	 * @param lang Language to the corresponding
	 * @param englishName compound name
	 * @param langName compound name(specified language)
	 */
	public static void addLangCompound(String lang, String englishName, String langName){
		compoundsNameList.add(englishName);
		compoundsLangNameList.add(langName);
		compoundsLangList.add(lang);
	}

	/**
	 * setting compound handler.
	 * @param handlerItemName
	 * @param compoundHandler
	 */
	public static void settingCompoundHandler(String handlerItemName, ICompoundHandler compoundHandler){
		ChemiCraftAPI.compoundHandlers.add(compoundHandler);
		compoundHandlerItemNames.add(handlerItemName);
	}

	//ȍ~VXe֌W̃\bh//////////////////////////////////////////////////////

	public static ArrayList<ICompoundHandler> getCompoundHandler(){
		compoundHandlers.trimToSize();
		return compoundHandlers;

	}

	public static ArrayList<String> getCompoundHandlerItemName(){
		compoundHandlerItemNames.trimToSize();
		return compoundHandlerItemNames;
	}

	public static ArrayList<String> getCompoundsName(){
		compoundsNameList.trimToSize();
		return compoundsNameList;
	}

	public static ArrayList<String> getCompoundsLangName(){
		compoundsLangNameList.trimToSize();
		return compoundsLangNameList;
	}

	public static ArrayList<String> getCompoundsLang(){
		compoundsLangList.trimToSize();
		return compoundsLangList;
	}

}
