<?php
////////////////////////////////////////
// アップロードファイルの削除CGI
////////////////////////////////////////
require_once __DIR__ . '/common.php';
require_once __DIR__ . '/access_ctrl.php';
require_once __DIR__ . '/calc_trip.php';
require_once __DIR__ . '/read_catalog.php';

header("Content-type: application/json; charset=utf-8");

$result = ['result' => 'error'];

// パラメータの取り出し

$selected_id = isset($_POST['selected_id']) ? $_POST['selected_id'] : '';
$verifydelkey = isset($_POST['verifydelkey']) ? $_POST['verifydelkey'] : '';
$verifytrip = isset($_POST['verifytrip']) ? $_POST['verifytrip'] : '';
$keytype = isset($_POST['keytype']) ? $_POST['keytype'] : '';

$hostaddr = get_hostaddr();

// データベースの検索
$pdo = create_pdo();

// アクセス制限中か？ (所定時間経過で自動解除)
$accessCtrl = new AccessCtrl($pdo);
if ($accessCtrl->getFailCount($hostaddr) > MAX_FAIL_COUNT) {
    $result = [
        'result' => 'error',
        'message' => '試行回数が上限値を超えました。しばらくお待ちください。'
    ];
    echo json_encode($result);
    exit;
}

$fetch = $pdo->prepare('select fname, author, delkey from ZIP_ENTRIES where id = ?');
$fetch->execute([$selected_id]);
$row = $fetch->fetch();
$fetch = null;

if ($row === false) {
    $result = [
        'result' => 'ok',
        'message' => 'already deleted.'
    ];
} else {
    $fname = $row['fname'];
    $author = $row['author'];
    $delkey = $row['delkey'];

    // トリップキーまたは削除キーの一致の確認
    $valid_key = false;
    if ($keytype === 'TRIP') {
        // トリップの場合
        $db_passphrase = get_trip_pass($author);
        $valid_key = ($db_passphrase !== '') && ($db_passphrase === "#$verifytrip");
    } else {
        // 削除キーの場合
        $valid_key = ($delkey === $verifydelkey);
    }
    
    if ($valid_key) {
        // トリップキーまたは削除キーが一致した場合
        append_log("delete ${selected_id}");

        $stm = $pdo->prepare('delete from ZIP_ENTRIES where id = ?');
        $stm->execute([$selected_id]);
        $stm = null;

        // タグ情報の削除
        $pc = new parse_catalog();
        $pc->unregister($selected_id);

        $result = [
            'result' => 'ok'
        ];

    } else {
        // キーの不一致によるエラー
        // 試行回数+1する
        append_log("unmatch delkey. zipid:${selected_id}");
        $accessCtrl->failIncrement($hostaddr);
        $result = [
            'result' => 'error',
            'message' => 'Authentication Failed'
        ];
    }
}
$accessCtrl = null;
$pdo = null;

echo json_encode($result);
?>