/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.BufferedImageWithKeyReference;
import charactermanaj.graphics.io.ImageCacheMBeanImpl;
import charactermanaj.graphics.io.LoadedImage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCache<K> {
    private static final Logger logger = Logger.getLogger(ImageCache.class.getName());
    private static final ImageCacheMBeanImpl imageCacheMBean = ImageCacheMBeanImpl.getSingleton();
    private HashMap<K, BufferedImageWithKeyReference<K>> lockedImages = new HashMap();
    private ReferenceQueue<LoadedImage> queue = new ReferenceQueue();
    private HashMap<K, BufferedImageWithKeyReference<K>> caches = new HashMap();

    public ImageCache() {
        imageCacheMBean.incrementInstance();
    }

    protected void finalize() throws Throwable {
        this.clear();
        imageCacheMBean.decrementInstance();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedImage get(K key) {
        if (key == null) {
            return null;
        }
        HashMap<K, BufferedImageWithKeyReference<K>> hashMap = this.caches;
        synchronized (hashMap) {
            BufferedImageWithKeyReference<K> ref = this.caches.get(key);
            LoadedImage img = null;
            if (ref != null) {
                img = (LoadedImage)ref.get();
            }
            imageCacheMBean.incrementReadCount(img != null);
            this.sweep();
            return img;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(K key, LoadedImage img) {
        if (key == null) {
            return;
        }
        HashMap<K, BufferedImageWithKeyReference<K>> hashMap = this.caches;
        synchronized (hashMap) {
            BufferedImageWithKeyReference<K> ref = this.caches.get(key);
            if (ref != null) {
                ref.enqueue();
            }
            if (img == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "remove cache: " + key);
                }
                this.caches.remove(key);
            } else {
                BufferedImageWithKeyReference<K> cacheData = new BufferedImageWithKeyReference<K>(key, img, this.queue);
                this.lockedImages.put(key, cacheData);
                this.caches.put(key, cacheData);
                imageCacheMBean.cacheIn(cacheData.getImageSize());
            }
            this.sweep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockImages() {
        HashMap<K, BufferedImageWithKeyReference<K>> hashMap = this.caches;
        synchronized (hashMap) {
            this.lockedImages.clear();
            this.sweep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<K, BufferedImageWithKeyReference<K>> hashMap = this.caches;
        synchronized (hashMap) {
            this.lockedImages.clear();
            for (BufferedImageWithKeyReference<K> ref : this.caches.values()) {
                ref.enqueue();
            }
            this.sweep();
            this.caches.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweep() {
        HashMap<K, BufferedImageWithKeyReference<K>> hashMap = this.caches;
        synchronized (hashMap) {
            Reference<LoadedImage> ref = null;
            boolean removed = false;
            while ((ref = this.queue.poll()) != null) {
                BufferedImageWithKeyReference r = (BufferedImageWithKeyReference)ref;
                Object key = r.getKey();
                if (key != null && this.caches.get(key).get() == null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "removed cache: " + key);
                    }
                    removed = true;
                    this.caches.remove(key);
                }
                int imageSize = r.getImageSize();
                imageCacheMBean.cacheOut(imageSize);
            }
            if (removed && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cache[" + Integer.toHexString(this.hashCode()) + "] size:" + this.caches.size());
            }
        }
    }
}

