/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImageBuildPartsInfo
implements Comparable<ImageBuildPartsInfo> {
    private int order;
    private Layer layer;
    private ImageResource imageResource;
    private ColorConvertParameter colorParam;

    public ImageBuildPartsInfo(int order, Layer layer, ImageResource imageResource, ColorConvertParameter colorParam) {
        this.order = order;
        this.layer = layer;
        this.imageResource = imageResource;
        this.colorParam = colorParam;
    }

    public int hashCode() {
        return this.order ^ this.layer.hashCode() ^ ((Object)this.imageResource).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof ImageBuildPartsInfo) {
            ImageBuildPartsInfo o = (ImageBuildPartsInfo)obj;
            return this.order == o.order && this.layer.equals(o.layer) && ((Object)this.imageResource).equals(o.imageResource) && this.colorParam.equals(o.colorParam);
        }
        return false;
    }

    @Override
    public int compareTo(ImageBuildPartsInfo o) {
        int ret = this.layer.compareTo(o.layer);
        if (ret == 0) {
            ret = this.order - o.order;
        }
        if (ret == 0) {
            ret = this.imageResource.compareTo(o.imageResource);
        }
        return ret;
    }

    public int getOrder() {
        return this.order;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public ColorConvertParameter getColorParam() {
        return this.colorParam;
    }

    public ImageResource getFile() {
        return this.imageResource;
    }
}

