#ifndef INCLUDED_TYPES
#define INCLUDED_TYPES

#include <stdint.h>

typedef uint16_t uint16;
typedef uint32_t uint32;
typedef uint64_t uint64;

//  HOST main memory address 
//       SPU's (void *) is always 32bit (actually 18bit (256kbyte))
//       memaddr is different from (void *) in SPU.
//
#ifdef __SPU__
#if ABIBIT>32
typedef uint64_t memaddr;
#else
typedef uint32_t memaddr;
#endif
#else
typedef char* memaddr;
#endif


#define Newq(Type,Count) ((Type *)malloc(sizeof(Type)*Count))
#define ReAlloc(Pointer,Type,Count) ((Type *)realloc((void*)Pointer,sizeof(Type)*Count))


#define SPE_ALIGNMENT 16
#define SPE_ALIGNMENT_FULL 128
#define SPE_ALIGN __attribute__((aligned(SPE_ALIGNMENT)))
#define SPE_ALIGN_FULL __attribute__((aligned(SPE_ALIGNMENT_FULL))
#define ROUND_UP_ALIGN(value, alignment) \
    (((value) + ((alignment) - 1))&(~((alignment)-1)))
#define DEFAULT_ALIGNMENT SPE_ALIGNMENT
//#define DEFAULT_ALIGNMENT SPE_ALIGNMENT_FULL

#define DMA_MAX_SIZE 16384

#define round_up16(value)  ROUND_UP_ALIGN(value, 16)
#define round_up128(value) ROUND_UP_ALIGN(value, 128)

#define TaskArray (-1)
#define TaskArray1 (-2)

// SPU 依存 (よろしくないが...)

// ここも typedef しとくか？
enum {
// どの方向かで enum 分けるだろjk...
// PPE -> SPE 
    MY_SPE_NOP = 0,
    MY_SPE_COMMAND_EXIT,
    MY_SPE_COMMAND_GO,

// SPE -> PPE
    MY_SPE_STATUS_BUSY,
    MY_SPE_STATUS_READY,
    MY_SPE_COMMAND_MALLOC,
};

#define MAX_USE_SPE_NUM 6

typedef enum {
    CPU_PPE = 0, // default
    CPU_SPE = 1,
    SPE_ANY = CPU_SPE,
    SPE_0 = 2,
    SPE_1 = 3,
    SPE_2 = 4,
    SPE_3 = 5,
    SPE_4 = 6,
    SPE_5 = 7,
} CPU_TYPE;

#endif
