#ifndef INCLUDED_TASK_MANAGER_IMPL
#define INCLUDED_TASK_MANAGER_IMPL

#include "MailManager.h"
#include "ListData.h"
#include "QueueInfo.h"
#include "TaskQueue.h"
#include "HTask.h"
#include "Scheduler.h"
class MemList;

extern QueueInfo<TaskQueue> *taskQueuePool ;
extern QueueInfo<HTask> *htaskPool ;
extern  QueueInfo<TaskList> *taskListPool;



class TaskManagerImpl {
public:

    /* variables */
    int machineNum;
    QueueInfo<HTask> *activeTaskQueue;
    QueueInfo<HTask> *waitTaskQueue;

    QueueInfo<TaskQueue> *taskQueueImpl;
    QueueInfo<HTask> *htaskImpl;

    SchedTask *schedTaskManager;
    Scheduler *scheduler;
    TaskManagerImpl *others;

    /* constructor */
    TaskManagerImpl(int num = 1) ;

    virtual ~TaskManagerImpl() { }

    /* functions */
    // system
    virtual void init() = 0;
    virtual void run() = 0;
    virtual void start_profile() = 0;
    virtual void show_profile() = 0;
    virtual void append_activeTask(HTaskPtr);
    virtual void append_waitTask(HTaskPtr);
    virtual void polling() = 0;

    void check_task_finish(HTaskPtr task, QueueInfo<HTask> *wait_queue);
    void check_task_list_finish(SchedTask *s, TaskListPtr list, QueueInfo<HTask> *wait_queue);

    void systask_init();

    // user
    virtual HTaskPtr create_task(int cmd,void *from);
    virtual HTaskPtr create_task(int cmd, memaddr rbuf, long r_size, memaddr wbuf, long w_size,void *from);
    virtual HTaskPtr create_task_array(int id, int num_task, int num_param, int num_inData, int num_outData,void *from);
    virtual void set_task_depend(HTaskPtr master, HTaskPtr slave);
    virtual void spawn_task(HTaskPtr);
    virtual void set_task_cpu(HTaskPtr, CPU_TYPE);
    void set_taskList(HTaskPtr htask, QueueInfo<TaskList> * taskList) ; 

    void free_htask(HTaskPtr htask) {
#if !defined(__SPU__)
	if (htask->self) {
	    htask->flag.no_auto_free = 0;
	    return;
	}
	htaskImpl->free_(htask);
#endif
    }

    void* allocate(int size, int alignment)
    {
	void *buff = 0;
	if (size==0) return 0;
#if defined(__SPU__) || ! defined(HAS_POSIX_MEMALIGN)
	buff =  malloc(size);
#else
	posix_memalign(&buff, alignment, size);
#endif
	if (buff==0) 
		get_scheduler()->printf("Can't allocate memory\n");
	return buff;
    }

    void* allocate(int size)
    {
	void *buff = 0;
	if (size==0) return 0;
#if defined(__SPU__) || ! defined(HAS_POSIX_MEMALIGN)
	buff =  malloc(size);
#else
	posix_memalign(&buff, DEFAULT_ALIGNMENT, size);
#endif
        if (buff==0)
		get_scheduler()->printf("Can't allocate memory\n");
	return buff;
    }

    Scheduler* get_scheduler() { return scheduler; }
    void set_scheduler(Scheduler *s) {  scheduler = s; }
}  __attribute__ ((aligned (DEFAULT_ALIGNMENT)));

#endif
