#ifndef INCLUDED_FIFO_TASK_MANAGER_IMPL
#define INCLUDED_FIFO_TASK_MANAGER_IMPL

#include "TaskManagerImpl.h"
#include "MainScheduler.h"
#include "Scheduler.h"

class FifoTaskManagerImpl : public TaskManagerImpl {
public:
    /* constructor */
    FifoTaskManagerImpl(int num = 1) : TaskManagerImpl(num) {}
    ~FifoTaskManagerImpl(void);

    /* variables */
    int machineNum;
    QueueInfo<TaskList> *taskListInfo;  
    QueueInfo<TaskList> *ppeTaskList;  // running task

    MailManager *mailManager;
    MainScheduler *mainScheduler;

    /* functions */
    // call by system
    void init();
    void init(MainScheduler*, TaskManagerImpl*);
    void poll();  // called from CellTaskManagerImpl
    void run();
    void show_profile()  {};
    void start_profile()  {};
    void polling();


    void mail_check();

    void set_runTaskList();
    void sendTaskList();

    // call by user

};


#endif /* INCLUDED_FIFO_TASK_MANAGER_IMPL */
