#ifndef INCLUDED_FIFO_DMA_MANAGER
#define INCLUDED_FIFO_DMA_MANAGER

#include "base.h"
#include "DmaManager.h"
#include "MailManager.h"

class FifoDmaManager : public DmaManager {

protected:
    /* variables */
    MailManagerPtr mail_queue1;
    MailManagerPtr mail_queue2;

public:
    BASE_NEW_DELETE(FifoDmaManager);

    FifoDmaManager() {
	mail_queue1 = new MailManager();
	mail_queue2 = new MailManager();
    }

    ~FifoDmaManager() {
	delete mail_queue1;
	delete mail_queue2;
    }

    /* functions */
    void dma_load(void *buf, memaddr addr, uint32 size, uint32 mask);
    void dma_store(void *buf, memaddr addr, uint32 size, uint32 mask);
    void dma_wait(uint32 mask) ;

    void mail_write(memaddr data) { mail_queue1->send(data); }
    memaddr mail_read() { return mail_queue2->recv(); }

    void mail_write_from_host(memaddr data) { mail_queue2->send(data); }
    memaddr mail_read_from_host() { return mail_queue1->recv(); }
    int has_mail_from_host() { return mail_queue1->count(); }

    void dma_loadList(ListDataPtr list, void *buff, uint32 mask);
    void dma_storeList(ListDataPtr, void *buff, uint32 mask);

};

#endif
