#ifndef INCLUDED_CELL_TASK_MANAGER_IMPL
#define INCLUDED_CELL_TASK_MANAGER_IMPL

#include "TaskManagerImpl.h"
#include "FifoTaskManagerImpl.h"
#include "SpeThreads.h"

class CellTaskManagerImpl : public TaskManagerImpl {
public:
    /* constructor */
    CellTaskManagerImpl(int num = 1) : TaskManagerImpl(num) {}
    ~CellTaskManagerImpl();

    /* variables */
    QueueInfo<TaskList> **taskListInfo;
    QueueInfo<TaskList> **speTaskList;  // running task

    SpeThreads *speThreads;
    FifoTaskManagerImpl *ppeManager;
    int spe_running;

    /* functions */
    // system
    void init();
    void run();
    void poll();
    void mail_check(int id);
    void set_runTaskList();
    void sendTaskList();
    void append_activeTask(HTaskPtr);
    void show_profile() ;
    void start_profile() ;
    void polling();

private:
    void send_taskList(int id);
    void show_dead_lock_info();

};

#endif
