#ifndef INCLUDED_CELL_DMA_MANAGER
#define INCLUDED_CELL_DMA_MANAGER

#include "base.h"
#include "types.h"
#include "DmaManager.h"

#include <spu_mfcio.h>

#define SPU_PROFILE 1

class Scheduler;

class CellDmaManager : public DmaManager {
public:
    BASE_NEW_DELETE(CellDmaManager);

    typedef struct dma_list {
	uint32 addr;  // should be memaddr, but in Cell's specification...
	uint32 size;
    }  __attribute__ ((aligned (DEFAULT_ALIGNMENT))) DmaList, *DmaListPtr;


    CellDmaManager() ;

    /* variables */
    unsigned int wait_time, busy_time;
    unsigned long long global_busy_time, global_wait_time, global_mail_time;
    unsigned long long task_array_load_time;

    /* functions */
    void dma_load(void *buf, memaddr addr, uint32 size, uint32 mask);
    void dma_store(void *buf, memaddr addr, uint32 size, uint32 mask);
    void dma_wait(uint32 mask) ;
    void dma_wait(uint32 mask, int cmd) ;
    void (CellDmaManager::*start_dmawait_profile)();
    void (CellDmaManager::*end_dmawait_profile)(unsigned long long *counter);
    void start_profile();
    void stop_profile();


    void show_dma_wait(Scheduler *s, int cpu);

    void mail_write(memaddr data);
    memaddr mail_read();
    void dma_loadList(ListDataPtr list, void *buff, uint32 mask);
    void dma_storeList(ListDataPtr, void *buff, uint32 mask);

    private:

    void do_start_dmawait_profile();
    void do_end_dmawait_profile(unsigned long long *counter);
    void null_start_dmawait_profile();
    void null_end_dmawait_profile(unsigned long long *counter);


/* end */
}  ;

#endif
