/**
 * OpenGLを用いてレンダリングを行うクラスです。
 * MacOSX上での高速な動作を目的としたViewerです。
 * ViewerとViewerDevice 一体型です。
 * 通常の計算(Move, Collision)はそのままです。
 * 描画の部分はTaskを使わず、OpenGLで直に描画します。
 **/

#ifndef INCLUDED_VIEWER_GL
#define INCLUDED_VIEWER_GL

#include <SDL.h>
#include <SDL_opengl.h>
#include "viewer_types.h"
#include "TaskManager.h"
#include "SceneGraphRoot.h"
#include "KeyStat.h"
#include "MainLoop.h"
#include "Application.h"
#include "Func.h"
#include "texture.h"
#include "lindaapi.h"


namespace OPENGL_PARAM {
    static const double near = -1000.0;
    static const double far = 1000.0;
    static const GLfloat lightAmbient[] = {0.25f, 0.25f, 0.25f};
    static const GLfloat lightDiffuse[] = {1.0f, 1.0f, 1.0f};
    static const GLfloat lightSpecular[] = {1.0f, 1.0f, 1.0f};
    static const GLfloat lightPosition[] = {0.5f, 0.5f, -1.0f, 0.0f};
}

class ViewerGL : public Viewer {
public:
    ViewerGL(TaskManager *m, int b, int w, int h, int _num);
    ~ViewerGL(){};
  
private:
    bool quit_flag;
  
    /* measure for FPS (Frame Per Second) */
    int start_time;
    int this_time;
    int frames;
  
public:
    void video_init(int bpp, int width, int height);
    void run_loop();
    void pickup_vertex();
    void obj_draw(float *xyz, float *tex_xyz, float *normal_xyz);
    void clean_pixels();
    void clear_screen();
  
    /* override function */
    void mainLoop();
    void run_finish();
};

#endif
