#ifndef INCLUDED_VIEWER
#define INCLUDED_VIEWER

#include <SDL.h>

#include "viewer_types.h"
#include "TaskManager.h"
#include "KeyStat.h"
#include "MainLoop.h"
#include "Application.h"
#include "SceneGraphRoot.h"
#include "ViewerDevice.h"
#include "matrix.h"

class SceneGraphRoot;

class Application;

typedef struct rendering_data {
    PolygonPack *ppack;
    SpanPackPtr spackList;
    SpanPackPtr *spackList_ptr;

    int spackList_length;
    int spackList_length_align;
} RederingData ;

extern RederingData r[2];

extern int  ppi, spi;

class Viewer : public MainLoop {

public:
    Viewer(){ profile = 0;};
    Viewer(TaskManager *manager, ViewerDevice *dev, int bpp, int width, int height, int spenum);

    virtual ~Viewer() {}
    BASE_NEW_DELETE(Viewer);

    ViewerDevice *dev;
    Application *app;

    TaskManager *manager;
    key_stat *keyPtr;
    HTaskPtr draw_dummy;

    /* screen info */
    int bpp;

    int rgb_size[3];
    int spe_num;
    int width;
    int height;

    float *light_xyz;
    float *light_xyz_stock;
    int *light_switch;
    int *light_switch_stock;
    int *light_sysswitch;
    int light_sysswitch_stock;

    Uint32 video_flags;
    Uint32 *pixels;

    int mem_flag;
    int profile;

    SceneGraphRoot *sgroot;

    //Uint32 *video_init(TaskManager *manager, int bpp, int width, int height);
    void init();

    int get_ticks();
    bool quit_check();
    void quit();
    HTaskPtr initLoop();

    void clean_pixels() {}

    void run_init(TaskManager *manager, Application *app);
    void run_loop(HTaskPtr task_next);
    void run_draw(HTaskPtr task_next);
    virtual void run_finish();
    void run_move(HTaskPtr task_next);
    void run_collision();
    void rendering(HTaskPtr task_next);
    void common_draw(HTaskPtr task_next);
    void common_rendering(HTaskPtr task_next, SceneGraphRoot *sgroot);

    void spe_rendering(HTaskPtr task_next);
    void spe_draw(HTaskPtr task_next);
    //  void exchange_sgroot(TaskManager *manager);

    HTaskPtr update_task_create(void *data, int size, 
				int load_id, int spe_id, HTaskPtr wait);

    void getKey();
    void get_send_controll();

    // void createFromXMLfile(const char *file);
    // SceneGraph *createSceneGraph(int id);
    // SceneGraph *createSceneGraph();
    // void setSceneData(SceneGraph *g);
    virtual void mainLoop();

    void set_game_task(int id, void *property, int size, PostFunction post_func)
    {
      sgroot->set_game_task(id, property, size, post_func);
    }
    void set_game_task(int id, void *property, void *pad, int size, PostFunction post_func)
    {
      sgroot->set_game_task(id, property, pad, size, post_func);
    }
    void set_move_task(SceneGraphPtr node, int move_id, void *titlep, int size, PostFunction post_func)
    {
      sgroot->set_move_task(node, move_id, titlep, size, post_func);
    }
    void set_pad_task(SceneGraphPtr node, int move, void *property, int size, PostFunction post_func)
    {
      sgroot->set_pad_task(node, move, property, size, post_func);
    }

    void createFromXMLmemory(SceneGraph * node, char *data, int len)
    {
	sgroot->createFromXMLmemory(manager, node, data, len);
    }

    void createFromXMLfile(const char *file)
    {
	sgroot->createFromXMLfile(manager, file);
    }

    Pad * getController()
    {
      return sgroot->getController();
    }

    SceneGraph * createSceneGraph(int id)
    {
	return sgroot->createSceneGraph(id);
    }

    SceneGraph * createSceneGraph(const char *id)
    {
        return sgroot->createSceneGraph(id);
    }

    int getSgid(const char *id)
    {
	return sgroot->getSgid(id);
    }

    SceneGraph * createSceneGraph()
    {
	return sgroot->createSceneGraph();
    }

    void setSceneData(SceneGraph *g)
    {
	sgroot->setSceneData(g);
    }

    int getLast()
    {
	return sgroot->getLast();
    }

    SceneGraphPtr getLight(int id)
    {
      return sgroot->getLight(id);
    }

    void OnLightSwitch(int id)
    {
      sgroot->OnLightSwitch(id);
    }

    void OffLightSwitch(int id)
    {
      sgroot->OffLightSwitch(id);
    }

    void OnLightSysSwitch()
    {
      sgroot->OnLightSysSwitch();
    }

    void OffLightSysSwitch()
    {
      sgroot->OffLightSysSwitch();
    }

};

#define default_sdl_flag SDL_INIT_TIMER | SDL_INIT_JOYSTICK


#endif

