#ifndef INCLUDED_TAPESTRY
#define INCLUDED_TAPESTRY

#include "types.h"
#include "viewer_types.h"
#include "MemorySegment.h"
#include "MemList.h"

/**
 * image file name と tapestry DB の binary tree
 *
 * // PPE
 * main memory の tapestry DB (Array)
 * tapestry DB への accessor
 *
 *   TapestryPtr getTapestry(int TapestryID);
 *   TilePtr getTile(TapestryPtr tapsetry, int tx, int ty, int scale);
 *
 * SPE が生成する tapestry List (in CreateSpan)
 *   (no texture image)
 *   @in  TapestryDBPtr, Tapestry ID, x, y, tx, ty, px, py
 *     x, y   : polygon の中の平面座標
 *     tx, ty : texture の座標
 *     px, py : texture の分割数
 *
 *   @out (TilePtr, tix1, tiy1, tix2, tiy2)*
 *
 *
 * SPE に渡す tapestry List
 *   @in Tile
 *
 * // SPE
 * SPE 内部での tapestry DB (Hash)
 *   TapestryID, scale, TilePtr, Tile
 *
 *
 * SPE 内部での tapestry DB への accessor
 *   TileEntryPtr getTile(int TapestryID, int tx, int ty, int scale);
 *
 *   if (TileEntry == NULL) {
 *      DMA read
 *   }
 *
 *
 * Rendering
 *   1pass Zbuffer と Texture の有無の判定
 *     if (zbuffer ok) {
 *       if (texture ある) {
 *         zbuffer 、linebunf に書き込む
 *       } else {
 *         texture の load list に加える
 *         zbuffer だけ更新しておく
 *       }
 *     } else {
 *       無視
 *     }
 *
 *    1pass で texture が一杯になったら、中断して
 *    ここまでのを書き込んどけ
 *
 *
 *    2pass rgb の書き込み
 *
 *    if (zbuffer の値が自分と一緒) {
 *       read した texture みて
 *       書き込め！
 *    }
 *
 */
struct texture_block {

};

typedef MemorySegment Tile, *TilePtr;

#define MAX_TILE 128

/**
 * TileList 中の Tile の追い出しは、現在 FIFO で実装している
 * これは汎用のサイズ別 freelist に置き換える
 * freelist は double linked list で、LRU をサポートする
*/
class TileList : public MemList {
    TileList(MemorySegment* ms) : MemList(ms) {}

/*!
  中身は同じ
 */
};

typedef TileList* TileListPtr;

#endif
