#ifndef INCLUDED_SPAN_PACK
#define INCLUDED_SPAN_PACK

#include "Span.h"

#define MAX_SIZE_SPAN 64

class SpanPack {
public: /* fields */
    struct SpanInfo {
	int start;
	int size;
	int y_top;
	int light_pos[3];
	int light_rgb[3];
    } info; // 36

    Span span[MAX_SIZE_SPAN]; // 48*MAX_SIZE_SPAN = 3072
    SpanPack *next; // 4

    int pad[2]; // 8

    void init(int ytop) {
	this->info.start = 0;
	this->info.size = 0;
	this->info.y_top = ytop;
	this->next = NULL;
    }

    void reinit(int ytop) {
	SpanPack* top = this;
	SpanPack* p;
	SpanPack* p1;

	p = top->next;
	while (p != NULL) {
	    p1 = p->next;
	    free(p);
	    p = p1;
	}
	
	this->info.start = 0;
	this->info.size = 0;
	this->info.y_top = ytop;
	this->next = NULL;
    }
};

typedef SpanPack* SpanPackPtr;

#endif
