#include <stdio.h>
#include "Renew3.h"
#include "SpeProfile.h"
#include "Func.h"

/* これは必須 */
SchedDefineTask(Renew3);

static int
run(SchedTask *s, void *rbuf, void *wbuf)
{
    SpeProfile *profile = (SpeProfile*) s->global_get(0);
    profile->ProfStop();
    profile->ProfPrint();

    s->printf("[SPE] ** running Renew3\n");
    
    s->printf("[SPE] Create Task : Renew4\n");
    HTaskPtr nextTask =  s->create_task(RENEW4);
    nextTask->spawn();
    
    s->printf("[SPE] ** finish  Renew3\n");
    s->printf("\n");

    profile->ProfStart();

    return 0;
}
