#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "TaskManager.h"
#include "SchedTask.h"
#include "Func.h"

extern void task_init();

const char *usr_help_str = "Usage: ./renew_task";

SchedDefineTask(RenewRepeat);

static int count = 1;
static int task_count = 1;

static void
renewRepeat1(SchedTask *s, void *arg, void *d)
{
    TaskManager *manager = (TaskManager *)arg;

    if (count-->0) {
	HTask *repeat = manager->create_task(RENEW_REPEAT);
	repeat->set_post(renewRepeat1, (void*)manager, 0);
	repeat->spawn();

	HTask *renew;

	printf("[PPE] Create Task : RenewStart\n\n");

	for(int i=0;i<task_count;i++) {
	    renew = manager->create_task(RENEW_START);
	    renew->set_cpu(SPE_ANY);
	    renew->add_param(i);
	    renew->add_param(&task_count);

	    // add Active Queue
	    renew->spawn();    
	}
    }
}

static int
run(SchedTask *s, void *rbuf, void *wbuf)
{
    // RewnewRepeat Task
    return 0;
}

static int
init(int argc, char **argv)
{
    for (int i = 1; argv[i]; ++i) {
        if (strcmp(argv[i], "-count") == 0) {
            count = atoi(argv[++i]);
        } else if (strcmp(argv[i], "-task") == 0) {
            task_count = atoi(argv[++i]);
        }


    }
    return 0;
}

static void
renew_init(TaskManager *manager)
{
    HTask *repeat;

    printf("[PPE] Create Task : RenewRepeat\n\n");

    repeat = manager->create_task(RENEW_REPEAT);
    repeat->set_post(renewRepeat1, (void*)manager, 0);

    // add Active Queue
    repeat->spawn();    
}

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    if (init(argc, argv) < 0) {
	return -1;
    }

    // Task Register
    //   ppe/task_init.cc
    task_init();

    printf("[PPE] Program Start\n\n");

    renew_init(manager);

    return 0;
}
