#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
#include "TaskManager.h"
#include "SchedTask.h"

#include "Func.h"
#include "sort.h"

extern void task_init();
extern int get_split_num(int len, int num);


// sort.cc
extern int data_length;
extern DataPtr data;
extern int all;
int all = 0;

static int sort_task = SortSimple;

// 計測用
static double st_time;
static double ed_time;

static int length = 1200;

// prototype
void TMend(TaskManager *);

static double
getTime()
{
    struct timeval tv;
    gettimeofday(&tv, NULL);
    return tv.tv_sec + (double)tv.tv_usec*1e-6;
}
/*
static void
show_data(void)
{
    puts("-----------------------------------------------");
    for(int i = 0; i < data_length; i++) {
	printf("data[%02d].index = %d\n", i, data[i].index);
    }
    puts("-----------------------------------------------");
}
*/

const char *usr_help_str = "Usage: ./sort [option]\n \
options\n\
  -cpu     Number of SPE used (default 1)\n\
  -l, --length  Sorted number of data (default 1200)\n\
  -h, --help    Print this message";

int
init(int argc, char **argv)
{
    for (int i = 1; argv[i]; ++i) {
        if (strcmp(argv[i], "--length") == 0 || strcmp(argv[i], "-l") == 0) {
            length = atoi(argv[++i]);
        }
        if (strcmp(argv[i], "-a") == 0 ) {
            all = 1;
        }
        if (strcmp(argv[i], "-c") == 0 ) {
            sort_task = SortCompat;
        }
        if (strcmp(argv[i], "-s") == 0 ) {
            sort_task = SortSimple;
        }

    }

    return 0;
}

Sort sorter;

static void 
check_data()
{
    for(int i=0; i< sorter.data_length-1;i++) {
        if (sorter.data[i].index>sorter.data[i+1].index)  {
            printf("Data are not sorted at %d. %d > %d \n",i, sorter.data[i].index,sorter.data[i+1].index);
            return;
        }
    }
    printf("Data are sorted\n");
}


static void
sort_init(SchedTask *manager, void *a, void *b)
{
    sorter.cpuNum = (long)a;
    long length = (long)b;

    sorter.data = (DataPtr)manager->allocate(sizeof(Data)*length);
    sorter.data_length = length;

    sorter.split_num = get_split_num(sorter.data_length, sorter.cpuNum); // data の分割数
    int half_num = sorter.split_num-1;
    sorter.fsort = (HTaskPtr*)manager->allocate(sizeof(HTaskPtr)*sorter.split_num);
    sorter.bsort = (HTaskPtr*)manager->allocate(sizeof(HTaskPtr)*half_num);
    memset((void*)sorter.bsort,0, sizeof(HTaskPtr)*half_num);

    for (int i = 0; i < length; i++) {
        sorter.data[i].index = manager->get_random()%10000;
        sorter.data[i].ptr   = i;
    }

    HTaskPtr restart = manager->create_task(sort_task,0,0,0,0);
    restart->set_param(0,(memaddr)&sorter);
    restart->spawn();
}

unsigned int ts, te;

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    if (init(argc, argv) < 0) {
	return -1;
    }

    task_init();

    int cpu  = manager->get_cpuNum();

    // in case of -cpu 0 
    if (cpu==0) cpu = 1;
    if (1) {
	HTask *dummy = manager->create_task(Dummy);
	dummy->set_post(sort_init, (void*)cpu, (void*)length);
	dummy->spawn();
    } else {
	sort_init(manager->get_schedTask(),(void*)cpu, (void*)length);
    }

    st_time = getTime();

    // 全ての Task が終了した後に実行する関数をセット
    manager->set_TMend(TMend);

    return 0;
}

void
TMend(TaskManager *manager)
{
    ed_time = getTime();
    //show_data();
    check_data();
    printf("Time: %0.6f\n",ed_time-st_time);
}

/* end */
