#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "TaskManager.h"
#include "Task.h"
#include "ListData.h"
#include "Func.h"

extern void task_init(void);

static int task_num = 1;
/*0 だと task_num が4つ以上の時に止まる。*/
static int data_count = 1;

const char *usr_help_str = "Usage: ./hello [-task task_num]\n\
  -task   Number of task (default 1)\n";

static int
init(int argc, char **argv)
{
    for (int i = 1; argv[i]; ++i) {

        if (strcmp(argv[i], "-task") == 0) {
            task_num = atoi(argv[++i]);
	}
    }

    return 0;
}


void
hello_init(TaskManager *manager)
{
    /**
     * Create Task
     *   create_task(Task ID);
     */ 
    
    /*うしろ3つ param/inData/outData の数を指定する*/
    HTask *twice_main = manager->create_task_array(Hello,task_num,data_count,data_count,data_count);
    Task *t = 0;

    for(int i = 0;i<task_num;i++) {
        t = twice_main->next_task_array(Hello, t);
    }
    twice_main->spawn_task_array(t->next());
    twice_main->set_cpu(SPE_ANY);
    twice_main->spawn();
}

int
TMmain(TaskManager *manager,int argc, char *argv[])
{

    if (init(argc, argv) < 0) {
	return -1;
    }

    // Task Register
    //   ppe/task_init.cc
    task_init();
    hello_init(manager);


    return 0;
}
