#include <SDL.h>

#ifndef INCLUDED_VIEWER
#define INCLUDED_VIEWER

#ifndef INCLUDED_VIEWER_TYPES
#  include "viewer_types.h"
#endif

#include "TaskManager.h"

extern TaskManager *manager;

class Viewer{
public:
    
    static int width;
    static int height;
    static int bpp;
    static int spe_num;
    int rgb_size[3];
    Uint32 video_flags;
    SDL_Surface *screen;
    Uint32 *pixels;
    //float zRow[1920][1080];
    float zRow[MAX_WIDTH][MAX_HEIGHT];

    Viewer(int b=32, int w=640, int h=480);
    Viewer(int b=32, int w=640, int h=480, int spenum = 1);
    void sdl_init();
    void init();
    int get_ticks();
    bool quit_check();
    void quit();
    void screen_clear();
    void swap_buffers();
    void write_pixel(int x, int y,float z, Uint32 rgb);
    void write_line(float x1, float y1, float x2, float y2, Uint32 rgb);
    void write_triangle(float x1, float y1, float x2, float y2, float x3, float y3, Uint32 rgb);
    void clean_pixels();
    void graph_line();

    //void run();
    void run_init(char *xml);
    void run_loop();
    void run_finish();
    void run_draw();

    void zRow_init();
};

#endif
