#include <iostream>
#include <SDL.h>
#include <math.h>
#include <unistd.h>
#include "viewer.h"
#include "polygon.h"
using namespace std;

Polygon *polygon;

#define redMask 0x00ff0000
#define greenMask 0x0000ff00
#define blueMask 0x000000ff
#define alphaMask 0

Viewer::Viewer(int b, int w, int h) {
	bpp = b;
	width = w;
	height = h;
}

void Viewer::sdl_init() {
	if( SDL_Init( SDL_INIT_VIDEO ) < 0) {
		fprintf(stderr,"Couldn't initialize SDL: %s\n", SDL_GetError());
		exit(1);
	}
#if 0
	screen = SDL_SetVideoMode( width, height, bpp, SDL_HWSURFACE);
	if(screen == NULL) {
		fprintf(stderr, "Couldn't set GL mode: %s\n", SDL_GetError());
		SDL_Quit();
		exit(1);
	}
#else 
	void *_pixels = new Uint32[width*height*32/8];
	screen = SDL_CreateRGBSurfaceFrom(_pixels, width, height, 32,
					  width*4, redMask, greenMask,
					  blueMask,alphaMask);
#endif
}

void Viewer::run_init() {
	polygon = new Polygon;	
	polygon->set_data("cube.xml");
	polygon->viewer = this;
}

